/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.converters;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeBuilder;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.FullDataRecord;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.data.converters.CSVDataConverterConfig;
import org.vikamine.kernel.data.converters.GenericDataTable;
import org.vikamine.kernel.util.ProgressBarPopupUpdater;

public class CSVDataConverter {
    private static final int MAX_INTEGER_DIGITS = 16;
    private static final int MAX_FRACTION_DIGITS = 16;
    private static final Locale LOCALE_STANDARD = new Locale("en");
    private static final String MISSING_VALUE_STRING = "?";

    public static DataRecordSet process(GenericDataTable csvTable, NumberFormat numberFormat, String dataSetName) throws IOException {
        String[] headers = csvTable.getHeader();
        ProgressBarPopupUpdater.init(csvTable.size() + headers.length + csvTable.size() * headers.length * 3);
        ArrayList parsedLines = new ArrayList(csvTable.size());
        int i = 0;
        while (i < csvTable.size()) {
            ProgressBarPopupUpdater.updateProgress();
            ArrayList<Object> tmpLine = new ArrayList<Object>(csvTable.getHeader().length);
            String[] stringArray = csvTable.getRow(i);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ((s = s.trim()).equals("")) {
                    tmpLine.add(MISSING_VALUE_STRING);
                } else {
                    ParsePosition parsePosition = new ParsePosition(0);
                    Number number = numberFormat.parse(s, parsePosition);
                    if (number != null && s.length() == parsePosition.getIndex()) {
                        tmpLine.add(number.doubleValue());
                    } else {
                        Double test = null;
                        try {
                            test = Double.valueOf(s);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (test != null) {
                            tmpLine.add(test);
                        } else {
                            tmpLine.add(CSVDataConverter.prepareStringValue(s));
                        }
                    }
                }
                ++n2;
            }
            parsedLines.add(tmpLine);
            ++i;
        }
        boolean[] isAttributeNominal = new boolean[headers.length];
        int lineIndex = 0;
        while (lineIndex < parsedLines.size()) {
            int attributeIndex = 0;
            while (attributeIndex < headers.length) {
                String string;
                Object attributeValue;
                ProgressBarPopupUpdater.updateProgress();
                if (!isAttributeNominal[attributeIndex] && (attributeValue = ((List)parsedLines.get(lineIndex)).get(attributeIndex)) instanceof String && !(string = (String)attributeValue).equals(MISSING_VALUE_STRING)) {
                    isAttributeNominal[attributeIndex] = true;
                }
                ++attributeIndex;
            }
            ++lineIndex;
        }
        ArrayList preDomains = new ArrayList();
        int i2 = 0;
        while (i2 < headers.length) {
            preDomains.add(new LinkedHashSet(10));
            ++i2;
        }
        int lineIndex2 = 0;
        while (lineIndex2 < parsedLines.size()) {
            int attributeIndex = 0;
            while (attributeIndex < headers.length) {
                Set tempDomain;
                Object e;
                Object castedValue;
                ProgressBarPopupUpdater.updateProgress();
                if (isAttributeNominal[attributeIndex] && !((String)(castedValue = (e = ((List)parsedLines.get(lineIndex2)).get(attributeIndex)) instanceof String ? (String)e : e.toString())).equals(MISSING_VALUE_STRING) && !(tempDomain = (Set)preDomains.get(attributeIndex)).contains(castedValue)) {
                    tempDomain.add(castedValue);
                }
                ++attributeIndex;
            }
            ++lineIndex2;
        }
        String[][] sortedDomains = new String[headers.length][];
        int i3 = 0;
        for (Set set : preDomains) {
            Object[] domain = new String[set.size()];
            int j = 0;
            for (String val : set) {
                domain[j] = val;
                ++j;
            }
            Arrays.sort(domain);
            sortedDomains[i3] = domain;
            ++i3;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(headers.length);
        AttributeBuilder attBuilder = new AttributeBuilder();
        int attributeIndex = 0;
        while (attributeIndex < headers.length) {
            ProgressBarPopupUpdater.updateProgress();
            String attributeName = headers[attributeIndex];
            if (isAttributeNominal[attributeIndex]) {
                attBuilder.buildNominalAttribute(attributeName, Arrays.asList(sortedDomains[attributeIndex]));
                attBuilder.buildNominalValues();
            } else {
                attBuilder.buildNumericAttribute(attributeName);
            }
            arrayList.add(attBuilder.getAttribute());
            ++attributeIndex;
        }
        DataRecordSet dataSet = new DataRecordSet(dataSetName, arrayList, parsedLines.size());
        int lineIndex3 = 0;
        while (lineIndex3 < parsedLines.size()) {
            List parsedLine = (List)parsedLines.get(lineIndex3);
            double[] values = new double[dataSet.getNumAttributes()];
            int attributeIndex2 = 0;
            while (attributeIndex2 < headers.length) {
                ProgressBarPopupUpdater.updateProgress();
                Object value = parsedLine.get(attributeIndex2);
                if (isAttributeNominal[attributeIndex2]) {
                    String castedValue = value instanceof String ? (String)value : value.toString();
                    if (castedValue.equals(MISSING_VALUE_STRING)) {
                        values[attributeIndex2] = Value.missingValue();
                    } else {
                        Object[] domain = sortedDomains[attributeIndex2];
                        int index = Arrays.binarySearch(domain, castedValue);
                        values[attributeIndex2] = index;
                    }
                } else if (value instanceof Double) {
                    values[attributeIndex2] = (Double)value;
                } else if (value.equals(MISSING_VALUE_STRING)) {
                    values[attributeIndex2] = Value.missingValue();
                }
                ++attributeIndex2;
            }
            dataSet.add(new FullDataRecord(1.0, values));
            ++lineIndex3;
        }
        return dataSet;
    }

    private static String prepareStringValue(String s) {
        String tmpString = s.replace(' ', '_');
        tmpString = tmpString.replace('\t', '_');
        return tmpString;
    }

    public static CSVDataConverterConfig getStandardCsvConfiguration() {
        CSVDataConverterConfig csvConfiguration = new CSVDataConverterConfig();
        csvConfiguration.separator = (char)44;
        csvConfiguration.quote = (char)34;
        csvConfiguration.numberFormat = CSVDataConverter.getStandardNumberFormat();
        csvConfiguration.comment = (char)35;
        return csvConfiguration;
    }

    public static CSVDataConverterConfig getGermanCsvConfiguration() {
        CSVDataConverterConfig csvConfiguration = new CSVDataConverterConfig();
        csvConfiguration.separator = (char)59;
        csvConfiguration.quote = (char)34;
        csvConfiguration.numberFormat = CSVDataConverter.getStandardNumberFormat(Locale.GERMAN);
        csvConfiguration.comment = (char)35;
        return csvConfiguration;
    }

    public static NumberFormat getStandardNumberFormat(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumIntegerDigits(16);
        numberFormat.setMaximumFractionDigits(16);
        return numberFormat;
    }

    public static NumberFormat getStandardNumberFormat() {
        return CSVDataConverter.getStandardNumberFormat(LOCALE_STANDARD);
    }
}

