/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.AbstractQFSimpleStatisticBased;
import org.vikamine.kernel.subgroup.quality.EstimatetableQFSimpleStatisticsBased;
import org.vikamine.kernel.subgroup.quality.functions.PrecisionQF;
import org.vikamine.kernel.subgroup.quality.functions.RecallQF;

public class FMeasureQF
extends AbstractQFSimpleStatisticBased
implements EstimatetableQFSimpleStatisticsBased {
    private static final String NAME = "F-Measure";
    double param;
    public static final PrecisionQF PRECISION_QF = new PrecisionQF();
    public static final RecallQF RECALL_QF = new RecallQF();

    public FMeasureQF() {
        this(1.0);
    }

    public FMeasureQF(double param) {
        this.param = param;
    }

    @Override
    public String getID() {
        return "FMeasureQF(" + this.param + ")";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double evaluateNum(double subgroupSize, double subgroupMean, double definedPopulationCount, double populationMean) {
        return Double.NaN;
    }

    @Override
    public double evaluateBin(double subgroupSize, double subgroupPositives, double definedPopulationCount, double populationPositives) {
        double precision = PRECISION_QF.evaluateBin(subgroupSize, subgroupPositives, definedPopulationCount, populationPositives);
        double recall = RECALL_QF.evaluateBin(subgroupSize, subgroupPositives, definedPopulationCount, populationPositives);
        return (1.0 + this.param * this.param) * (precision * recall) / (this.param * this.param * precision + recall);
    }

    @Override
    public AbstractQFSimpleStatisticBased clone() {
        return new FMeasureQF(this.param);
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget() != null && subgroup.getTarget().isBoolean();
    }

    @Override
    public double estimateQuality(double subgroupSize, double subgroupPositives, double populationSize, double populationPositives) {
        return 1.0;
    }
}

