## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(safeframe)
library(dplyr)

x <- make_safeframe(
  cars,
  mph = "speed",
  distance = "dist"
)

head(x)

## -----------------------------------------------------------------------------
x %>%
  arrange(speed) %>%
  head()

## -----------------------------------------------------------------------------
x %>%
  distinct() %>%
  head()

## -----------------------------------------------------------------------------
x %>%
  filter(speed >= 5) %>%
  head()

## -----------------------------------------------------------------------------
x %>%
  slice(5:10)

x %>%
  slice_head(n = 5)

x %>%
  slice_tail(n = 5)

x %>%
  slice_min(speed, n = 3)

x %>%
  slice_max(speed, n = 3)

x %>%
  slice_sample(n = 5)

## -----------------------------------------------------------------------------
x %>%
  count(speed) %>%
  head()

## -----------------------------------------------------------------------------
# In place modification doesn't lose tags
x %>%
  mutate(speed = speed + 10) %>%
  head()

# New columns don't affect existing tags
x %>%
  mutate(ticket = speed >= 50) %>%
  head()

# .keep = "unused" generate expected tag loss conditions
x %>%
  mutate(edad = speed, .keep = "unused") %>%
  head()

## -----------------------------------------------------------------------------
x %>%
  pull(speed)

## -----------------------------------------------------------------------------
x %>%
  relocate(speed, .before = 1) %>%
  head()

## -----------------------------------------------------------------------------
x %>%
  rename(edad = speed) %>%
  head()

x %>%
  rename_with(toupper) %>%
  head()

## -----------------------------------------------------------------------------
# Works fine
x %>%
  select(speed, dist) %>%
  head()

# tags are updated!
x %>%
  select(dist, edad = speed) %>%
  head()

## -----------------------------------------------------------------------------
# Does not retain tags
x %>%
  group_by(speed) %>%
  head()

## -----------------------------------------------------------------------------
dim(x)

dim(bind_rows(x, x))

## -----------------------------------------------------------------------------
bind_cols(
  suppressWarnings(select(x, speed)),
  suppressWarnings(select(x, dist))
) %>%
  head()

## -----------------------------------------------------------------------------
full_join(
  suppressWarnings(select(x, speed, dist)),
  suppressWarnings(select(x, dist, speed))
) %>%
  head()

## -----------------------------------------------------------------------------
x %>%
  dplyr::arrange(dplyr::pick(ends_with("loc"))) %>%
  head()

