/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.http.apache.client.impl;

import com.simba.athena.amazonaws.http.AmazonHttpClient;
import com.simba.athena.amazonaws.http.IdleConnectionReaper;
import com.simba.athena.amazonaws.http.apache.SdkProxyRoutePlanner;
import com.simba.athena.amazonaws.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.simba.athena.amazonaws.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import com.simba.athena.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import com.simba.athena.amazonaws.http.apache.client.impl.SdkHttpClient;
import com.simba.athena.amazonaws.http.apache.utils.ApacheUtils;
import com.simba.athena.amazonaws.http.client.ConnectionManagerFactory;
import com.simba.athena.amazonaws.http.client.HttpClientFactory;
import com.simba.athena.amazonaws.http.conn.ClientConnectionManagerFactory;
import com.simba.athena.amazonaws.http.conn.SdkConnectionKeepAliveStrategy;
import com.simba.athena.amazonaws.http.protocol.SdkHttpRequestExecutor;
import com.simba.athena.amazonaws.http.settings.HttpClientSettings;
import com.simba.athena.shaded.apache.commons.logging.Log;
import com.simba.athena.shaded.apache.commons.logging.LogFactory;
import com.simba.athena.shaded.apache.http.conn.ConnectionKeepAliveStrategy;
import com.simba.athena.shaded.apache.http.conn.HttpClientConnectionManager;
import com.simba.athena.shaded.apache.http.impl.client.HttpClientBuilder;
import com.simba.athena.shaded.apache.http.impl.client.HttpClients;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst(itcp);
        } else {
            builder.addInterceptorLast(itcp);
        }
        this.addProxyConfig(builder, settings);
        SdkHttpClient httpClient = new SdkHttpClient(builder.build(), cm);
        if (settings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm, settings.getMaxIdleConnectionTime());
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (settings.isProxyEnabled()) {
            LOG.info("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort());
            builder.setRoutePlanner(new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getProxyProtocol(), settings.getNonProxyHosts()));
            if (settings.isAuthenticatedProxy()) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings) {
        return settings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings.getMaxIdleConnectionTime()) : null;
    }
}

