/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;

public class AJCatalogOnlyMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private boolean m_hasStartedFetch = false;

    public AJCatalogOnlyMetadataSource(ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData("AwsDataCatalog", dataWrapper, l, l2);
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedFetch;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_hasStartedFetch) {
            return false;
        }
        this.m_hasStartedFetch = true;
        return true;
    }
}

