/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.misc;

import dr.evolution.tree.NodeRef;
import dr.evomodel.antigenic.phyloclustering.TreeClusteringVirusesPrior;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Random;

public class simulateClusters {
    public static final String CLASSNAME = "SimulateClustersAndHI";
    private TreeModel treeModel;
    private int[] clusterLabels;
    private Parameter indicators;
    private MatrixParameter virusLocations;
    int[] membershipToClusterLabelIndexes = null;
    private Parameter virusOffsets;
    private int[] correspondingTreeIndexForVirus = null;
    private double[][] distCluster;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String EXCISIONPOINTS = "excisionPoints";
        public static final String CLUSTERLABELS = "clusterLabels";
        public static final String CLUSTERLABELSTREENODE = "clusterLabelsTreeNode";
        public static final String MU = "mu";
        public static final String OFFSETS = "offsets";
        public static final String VIRUS_LOCATIONS = "virusLocations";
        public static final String VIRUS_LOCATIONSTREENODE = "virusLocationsTreeNodes";
        public static final String INDICATORS = "indicators";
        public static final String VIRUS_OFFSETS = "virusOffsets";
        boolean integrate = false;
        public static final String MUPRECISION = "muPrecision";
        public static final String PROBACTIVENODE = "probActiveNode";
        public static final String INITIALNUMCLUSTERS = "numClusters";
        public static final String NUMSERA = "numSeraPerCluster";
        public static final String MUMEAN = "muMean";
        public static final String FILE_NAME = "HIFile";
        public static final String FILE_NAME2 = "distClusterFile";
        public static final String SEEDNUM = "seed";
        public static final String MINSIZECLUSTER = "minClusterSize";
        public static final String MEANHOMOLOGOUSTITER = "meanHomologousLog2Titer";
        public static final String UNITPERTRANSITION = "log2TiterDiffPerTransition";
        public static final String MEASUREMENTNOISEVAR = "measurementNoiseVariance";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("HIFile", false, "The name of the file containing the assay table"), AttributeRule.newStringRule("distClusterFile", false, "The name of the file containing the assay table"), AttributeRule.newIntegerRule("numClusters", true, "the initial number of clusters"), AttributeRule.newIntegerRule("seed", true, "the initial number of clusters"), AttributeRule.newIntegerRule("numSeraPerCluster", true, "number of sera to simulate"), AttributeRule.newIntegerRule("minClusterSize", true, "The minimum cluster size of a virus"), AttributeRule.newDoubleRule("meanHomologousLog2Titer", true, "the expected log2 titer of a homologous virus"), AttributeRule.newDoubleRule("log2TiterDiffPerTransition", true, "the expected decrease in log2 titer value per major transition"), AttributeRule.newDoubleRule("measurementNoiseVariance", true, "the variance of the measurement noise in the log2 titer value"), new ElementRule(TreeModel.class), new ElementRule("indicators", Parameter.class), new ElementRule("virusLocations", MatrixParameter.class), new ElementRule("virusOffsets", Parameter.class)};

        @Override
        public String getParserName() {
            return simulateClusters.CLASSNAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = 10;
            if (xMLObject.hasAttribute(INITIALNUMCLUSTERS)) {
                n = xMLObject.getIntegerAttribute(INITIALNUMCLUSTERS);
            }
            int n2 = 10;
            if (xMLObject.hasAttribute(NUMSERA)) {
                n2 = xMLObject.getIntegerAttribute(NUMSERA);
            }
            int n3 = (int)Math.floor(Math.random() * 100000.0);
            if (xMLObject.hasAttribute(SEEDNUM)) {
                n3 = xMLObject.getIntegerAttribute(SEEDNUM);
            }
            int n4 = 5;
            if (xMLObject.hasAttribute(MINSIZECLUSTER)) {
                n4 = xMLObject.getIntegerAttribute(MINSIZECLUSTER);
            }
            double d = 10.0;
            if (xMLObject.hasAttribute(MEANHOMOLOGOUSTITER)) {
                d = xMLObject.getDoubleAttribute(MEANHOMOLOGOUSTITER);
            }
            double d2 = 2.0;
            if (xMLObject.hasAttribute(UNITPERTRANSITION)) {
                d2 = xMLObject.getDoubleAttribute(UNITPERTRANSITION);
            }
            double d3 = 1.0;
            if (xMLObject.hasAttribute(MEASUREMENTNOISEVAR)) {
                d3 = xMLObject.getDoubleAttribute(MEASUREMENTNOISEVAR);
            }
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            XMLObject xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(VIRUS_LOCATIONS);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(VIRUS_OFFSETS);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            String string = xMLObject.getStringAttribute(FILE_NAME);
            String string2 = xMLObject.getStringAttribute(FILE_NAME2);
            return new simulateClusters(treeModel, parameter, n, n2, matrixParameter, parameter2, string, string2, n3, n4, d, d2, d3);
        }

        @Override
        public String getParserDescription() {
            return "tree clustering viruses";
        }

        @Override
        public Class getReturnType() {
            return TreeClusteringVirusesPrior.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    String Atribute = null;

    public simulateClusters(TreeModel treeModel, Parameter parameter, int n, int n2, MatrixParameter matrixParameter, Parameter parameter2, String string, String string2, int n3, int n4, double d, double d2, double d3) {
        int n5;
        int n6;
        File file;
        int n7;
        int n8;
        Random random = new Random(n3);
        System.out.println("loading the constructor for SimulateCluster and HI");
        TreeModel treeModel2 = treeModel;
        this.treeModel = treeModel;
        this.indicators = parameter;
        this.virusLocations = matrixParameter;
        this.virusOffsets = parameter2;
        System.out.println("sera per cluster = " + n2);
        System.out.println("nClusters = " + n);
        System.out.println("minimum cluster size = " + n4);
        System.out.println("meanHomologousTiter = " + d);
        System.out.println("unit per transition = " + d2);
        System.out.println("measurement noise variance = " + d3);
        System.out.println("seedNum = " + n3);
        for (n8 = 0; n8 < treeModel2.getNodeCount(); ++n8) {
            this.indicators.setParameterValue(n8, 0.0);
        }
        n8 = this.virusLocations.getColumnDimension();
        int n9 = treeModel2.getNodeCount();
        this.setMembershipToClusterLabelIndexes();
        this.distCluster = new double[n][];
        for (int i = 0; i < n; ++i) {
            this.distCluster[i] = new double[n];
        }
        int[] nArray = new int[1];
        double[][] dArray = new double[1][1];
        this.indicators.setParameterValue(treeModel2.getRoot().getNumber(), 1.0);
        int n10 = 1;
        while (n10 < n) {
            int n11;
            int n12;
            while ((int)this.indicators.getParameterValue(n7 = (int)Math.floor(random.nextDouble() * (double)n9)) == 1) {
            }
            this.indicators.setParameterValue(n7, 1.0);
            this.setClusterLabelsUsingIndicatorsAndCalculateDiff();
            nArray = new int[++n10];
            dArray = new double[n10][n8];
            for (n12 = 0; n12 < n8; ++n12) {
                dArray[this.clusterLabels[n12]][nArray[this.clusterLabels[n12]]] = this.virusOffsets.getParameterValue(n12);
                int n13 = this.clusterLabels[n12];
                nArray[n13] = nArray[n13] + 1;
            }
            n12 = 1;
            for (n11 = 0; n11 < n10; ++n11) {
                if (nArray[n11] >= n4) continue;
                n12 = 0;
            }
            if (n12 == 1) {
                for (n11 = 0; n11 < n10; ++n11) {
                    System.out.print("cluster " + n11 + " size = " + nArray[n11] + "\t");
                    for (int i = 0; i < nArray[n11]; ++i) {
                        System.out.print(dArray[n11][i] + ",");
                    }
                    System.out.println("");
                }
                System.out.println("===========================================================");
            }
            if (n12 != 0) continue;
            this.indicators.setParameterValue(n7, 0.0);
            --n10;
        }
        System.out.println("Cluster labels: ");
        for (n7 = 0; n7 < n8; ++n7) {
            Parameter parameter3 = this.virusLocations.getParameter(n7);
            String string3 = parameter3.getParameterName();
            System.out.println(string3 + "\t" + this.clusterLabels[n7]);
        }
        System.out.println("==============================================================");
        System.out.println("Indicators that are on:");
        for (n7 = 0; n7 < n9; ++n7) {
            if ((int)this.indicators.getParameterValue(n7) != 1) continue;
            System.out.println(n7);
        }
        System.out.println("===============================================================");
        try {
            System.out.println("distClusterFile = " + string2);
            file = new File(string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (n6 = 0; n6 < n; ++n6) {
                for (n5 = 0; n5 < n; ++n5) {
                    System.out.print(this.distCluster[n6][n5] + " ");
                    bufferedWriter.write(this.distCluster[n6][n5] + " ");
                }
                System.out.println("");
                bufferedWriter.write("\n");
            }
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            System.err.println("Problem writing to the file");
        }
        System.out.println("===============================================================");
        try {
            System.out.println("HIFile = " + string);
            file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("virusIsolate\tvirusStrain\tvirusYear\tserumIsolate\tserumStrain\tserumYear\ttiter\tsource\n");
            System.out.println("virusIsolate    virusStrain     virusYear       serumIsolate    serumStrain     serumYear       titer   source");
            for (n6 = 0; n6 < n; ++n6) {
                for (n5 = 0; n5 < n2; ++n5) {
                    int n14 = (int)Math.floor(random.nextDouble() * (double)nArray[n6]);
                    double d4 = dArray[n6][n14];
                    for (int i = 0; i < n8; ++i) {
                        double[] dArray2 = new double[]{d - this.distCluster[n6][this.clusterLabels[i]] * d2};
                        double[][] dArray3 = new double[1][1];
                        dArray3[0][0] = 1.0 / d3;
                        double[] dArray4 = MultivariateNormalDistribution.nextMultivariateNormalPrecision(dArray2, dArray3);
                        Parameter parameter4 = this.virusLocations.getParameter(i);
                        String string4 = parameter4.getParameterName();
                        bufferedWriter.write("C" + this.clusterLabels[i] + "\t" + string4 + "\t" + this.virusOffsets.getParameterValue(i) + "\t");
                        bufferedWriter.write("c" + n6 + "s" + (n5 + 1) + "\tc" + n6 + "s" + (n5 + 1) + "\t" + d4 + "\t");
                        bufferedWriter.write(Math.pow(2.0, dArray4[0]) + "\tsimulation\n");
                    }
                }
            }
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            System.err.println("Problem writing to the file");
        }
    }

    private void setMembershipToClusterLabelIndexes() {
        int n = this.virusLocations.getColumnDimension();
        int n2 = this.treeModel.getNodeCount();
        this.membershipToClusterLabelIndexes = new int[n];
        this.clusterLabels = new int[n];
        for (int i = 0; i < n; ++i) {
            Parameter parameter = this.virusLocations.getParameter(i);
            String string = parameter.getParameterName();
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                String string2 = this.treeModel.getTaxonId(j);
                if (!string.equals(string2)) continue;
                this.membershipToClusterLabelIndexes[i] = j;
                bl = true;
                break;
            }
            if (bl) continue;
            System.out.println("not found. Exit now.");
            System.exit(0);
        }
    }

    private void setClusterLabelsUsingIndicatorsAndCalculateDiff() {
        int[] nArray = this.determine_membership_v3(this.treeModel);
        int n = this.virusLocations.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            this.clusterLabels[i] = nArray[this.membershipToClusterLabelIndexes[i]];
        }
    }

    int[] determine_membership_v3(TreeModel treeModel) {
        NodeRef nodeRef = treeModel.getRoot();
        int n = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray[i] = -1;
        }
        nArray[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            int n2;
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                if ((int)this.indicators.getParameterValue(nodeRef2.getNumber()) == 1) {
                    nArray[nodeRef2.getNumber()] = ++n - 1;
                    n2 = nArray[treeModel.getParent(nodeRef2).getNumber()];
                    for (int i = 0; i < n - 1; ++i) {
                        this.distCluster[n - 1][i] = this.distCluster[n2][i] + 1.0;
                        this.distCluster[i][n - 1] = this.distCluster[i][n2] + 1.0;
                    }
                } else {
                    nArray[nodeRef2.getNumber()] = nArray[treeModel.getParent(nodeRef2).getNumber()];
                }
            }
            string = string + " cluster = " + nArray[nodeRef2.getNumber()];
            for (n2 = 0; n2 < treeModel.getChildCount(nodeRef2); ++n2) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, n2));
            }
        }
        return nArray;
    }

    int[] determine_from_membership_v2(TreeModel treeModel) {
        int[] nArray = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray[i] = -1;
        }
        NodeRef nodeRef = treeModel.getRoot();
        int n = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray2 = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray2[i] = -1;
        }
        nArray2[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                if ((int)this.indicators.getParameterValue(nodeRef2.getNumber()) == 1) {
                    nArray2[nodeRef2.getNumber()] = ++n - 1;
                    nArray[n - 1] = nArray2[treeModel.getParent(nodeRef2).getNumber()];
                } else {
                    nArray2[nodeRef2.getNumber()] = nArray2[treeModel.getParent(nodeRef2).getNumber()];
                }
            }
            string = string + " cluster = " + nArray2[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray;
    }

    public Model getModel() {
        return null;
    }

    public double getLogLikelihood() {
        return 0.0;
    }

    public void makeDirty() {
    }
}

