/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.operators;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class muPrecisionInactiveMuOperator
extends AbstractAdaptableOperator {
    private Parameter muPrecision = null;
    private MatrixParameter mu = null;
    private Parameter indicators = null;
    private double scaleFactor;
    private Parameter muMean = null;
    public static final String CLASSNAME = "muPrecisionInactiveMuOperator";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String MU = "mu";
        public static final String MUPREC = "muPrec";
        public static final String SCALE = "scaleFactor";
        public static final String MUMEAN = "muMean";
        public static final String INDICATORS = "indicators";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("scaleFactor"), new ElementRule("mu", Parameter.class), new ElementRule("muPrec", Parameter.class), new ElementRule("indicators", Parameter.class), new ElementRule("muMean", Parameter.class)};

        @Override
        public String getParserName() {
            return muPrecisionInactiveMuOperator.CLASSNAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(SCALE);
            XMLObject xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(MUPREC);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MUMEAN);
            Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
            return new muPrecisionInactiveMuOperator(d, matrixParameter, parameter, d2, parameter2, parameter3);
        }

        @Override
        public String getParserDescription() {
            return "changes serum drift and make sure the first dimension of the active drifted mus stay the same";
        }

        @Override
        public Class getReturnType() {
            return muPrecisionInactiveMuOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public muPrecisionInactiveMuOperator(double d, MatrixParameter matrixParameter, Parameter parameter, double d2, Parameter parameter2, Parameter parameter3) {
        super(AdaptationMode.ADAPTATION_ON);
        this.setWeight(d);
        this.mu = matrixParameter;
        this.muPrecision = parameter;
        this.scaleFactor = d2;
        this.indicators = parameter2;
        this.muMean = parameter3;
    }

    @Override
    public double doOperation() {
        double d = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        double d2 = this.muPrecision.getParameterValue(0);
        double d3 = d * d2;
        this.muPrecision.setParameterValue(0, d3);
        for (int i = 0; i < this.mu.getColumnDimension(); ++i) {
            if (this.indicators.getParameterValue(i) != 0.0) continue;
            for (int j = 0; j < 2; ++j) {
                double d4;
                double d5;
                if (j == 0) {
                    d5 = this.mu.getParameter(i).getParameterValue(j) - this.muMean.getParameterValue(0);
                    d4 = d5 * Math.sqrt(d2 / d3) + this.muMean.getParameterValue(0);
                    this.mu.getParameter(i).setParameterValue(j, d4);
                    continue;
                }
                d5 = this.mu.getParameter(i).getParameterValue(j);
                d4 = d5 * Math.sqrt(d2 / d3);
                this.mu.getParameter(i).setParameterValue(j, d4);
            }
        }
        double d6 = -Math.log(d);
        return d6;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.exp(d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    @Override
    public final String getOperatorName() {
        return CLASSNAME;
    }

    public int getStepCount() {
        return 1;
    }
}

