/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.MutableTreeModel;
import dr.evomodel.treelikelihood.AbstractTreeLikelihood;

public abstract class AbstractSinglePartitionTreeLikelihood
extends AbstractTreeLikelihood {
    protected PatternList patternList = null;
    protected DataType dataType = null;
    protected double[] patternWeights;
    protected int patternCount;
    protected int stateCount;
    protected boolean[] updatePattern = null;

    public AbstractSinglePartitionTreeLikelihood(String string, PatternList patternList, MutableTreeModel mutableTreeModel) {
        super(string, mutableTreeModel);
        this.patternList = patternList;
        this.dataType = patternList.getDataType();
        this.patternCount = patternList.getPatternCount();
        this.stateCount = this.dataType.getStateCount();
        this.patternWeights = patternList.getPatternWeights();
    }

    protected void updatePattern(int n) {
        if (this.updatePattern != null) {
            this.updatePattern[n] = true;
        }
        this.likelihoodKnown = false;
    }

    protected void updateAllPatterns() {
        if (this.updatePattern != null) {
            for (int i = 0; i < this.patternCount; ++i) {
                this.updatePattern[i] = true;
            }
        }
        this.likelihoodKnown = false;
    }

    public final double[] getPatternWeights() {
        return this.patternWeights;
    }

    @Override
    public void makeDirty() {
        super.makeDirty();
        this.updateAllPatterns();
    }
}

