/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.text;

import edu.cens.text.DeducerOkCancelPanel;
import edu.cens.text.PreprocessingTable;
import edu.cens.text.ProcessCmd;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.ObjectChooserWidget;

public class PreprocessingDialog
extends JDialog {
    PreprocessingTable _table;
    private static final String HELP_URL = "http://www.deducer.org/pmwiki/index.php?n=Main.PreprocessCorpus";
    protected ObjectChooserWidget _source = new ObjectChooserWidget("Source Corpus:", this){
        {
            this.setClassFilter("Corpus");
            this.refreshObjects();
        }
    };
    private JTextField saveAsNameField = new JTextField(15);
    private DefaultListModel _model = new DefaultListModel();
    private boolean debugForceShow;

    public PreprocessingDialog(JFrame jFrame) {
        super(jFrame);
        int n = ProcessCmd.values().length;
        for (int i = 0; i < n; ++i) {
            this._model.addElement(ProcessCmd.values()[i]);
        }
        this.debugForceShow = false;
        this.setTitle("Preprocess Corpus...");
        this._source.getComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PreprocessingDialog.this.saveAsNameField != null) {
                    String string = Deducer.getUniqueName((String)(PreprocessingDialog.this._source.getComboBox().getSelectedItem() + ".processed"));
                    PreprocessingDialog.this.saveAsNameField.setText(string);
                }
            }
        });
        if (this._source.getComboBox().getModel().getSize() > 0) {
            this._source.getComboBox().setSelectedIndex(0);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JPanel(){
            {
                this.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 2;
                this.add((Component)PreprocessingDialog.this._source, gridBagConstraints);
                ++gridBagConstraints.gridy;
                int n = ProcessCmd.values().length;
                PreprocessingDialog.this._table = new PreprocessingTable(n);
                for (int i = 0; i < n; ++i) {
                    PreprocessingDialog.this._table.setAction((Object)ProcessCmd.values()[i], i);
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem[] jMenuItemArray = ProcessCmd.values()[i].getExtraOptions();
                    ProcessCmd.values()[i].setParentComponent(PreprocessingDialog.this._table);
                    for (JMenuItem jMenuItem : jMenuItemArray) {
                        jPopupMenu.add(jMenuItem);
                    }
                    PreprocessingDialog.this._table.setHasOption(jMenuItemArray.length > 0, i);
                    PreprocessingDialog.this._table.setOptionsMenu(jPopupMenu, i);
                }
                PreprocessingDialog.this._table.setEnabled(4, false);
                PreprocessingDialog.this._table.setEnabled(5, false);
                JPanel jPanel = new JPanel();
                jPanel.setBorder(BorderFactory.createTitledBorder("Actions:"));
                jPanel.add(PreprocessingDialog.this._table);
                this.add((Component)jPanel, gridBagConstraints);
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 1;
                this.add((Component)new JLabel(), gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.insets = new Insets(0, 15, 0, 0);
                gridBagConstraints.ipadx = 10;
                this.add((Component)new JLabel("Save Corpus As:"), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)PreprocessingDialog.this.saveAsNameField, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 2;
                this.add((Component)new DeducerOkCancelPanel(this.getRootPane(), "Save as:", "Cancel", PreprocessingDialog.HELP_URL){

                    protected void ok() {
                        PreprocessingDialog.this.doOK();
                    }

                    protected void cancel() {
                        PreprocessingDialog.this.doCancel();
                    }
                }, gridBagConstraints);
            }
        }, gridBagConstraints);
        this.pack();
        this.setResizable(false);
        this.setMinimumSize(this.getSize());
    }

    public boolean doCancel() {
        this.dispose();
        return true;
    }

    public boolean doOK() {
        if (this._source.getComboBox().getSelectedItem() == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.getContentPane(), "You do not have any corpuses to preprocess.", "Error", 0);
            return false;
        }
        if (this.saveAsNameField.getText() == null || this.saveAsNameField.getText().equals("")) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.getContentPane(), "No name given for the processed corpus.\nPlease choose a valid name.", "Error", 0);
            return false;
        }
        String string = this._source.getComboBox().getSelectedItem().toString();
        String string2 = this.saveAsNameField.getText();
        int n = 0;
        String string3 = "";
        for (int i = 0; i < ProcessCmd.values().length; ++i) {
            if (!this._table.isEnabled(i)) continue;
            ++n;
            ProcessCmd processCmd = (ProcessCmd)((Object)this._table.getAction(i));
            string3 = string3 + string2 + "<- " + processCmd.getRCmd(string) + "\n";
            string = string2;
        }
        Deducer.execute((String)string3);
        if (n == 0) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.getContentPane(), "No preprocessing actions were selected!\nYou can enable an action by checking the box next to its name.", "Warning", 2);
            return false;
        }
        this.setVisible(false);
        return true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocationRelativeTo(this.getParent());
        }
        if (bl && this._source.getModel() == null && !this.debugForceShow) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.getContentPane(), "You have not yet created any corpuses.\nCreate a corpus with \"Extract Corpus\" in the Text menu.", "Warning", 2);
        }
        super.setVisible(bl);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        PreprocessingDialog preprocessingDialog = new PreprocessingDialog(null);
        jFrame.setVisible(true);
        preprocessingDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        preprocessingDialog.debugForceShow = true;
        preprocessingDialog.setVisible(true);
        preprocessingDialog.setDefaultCloseOperation(2);
    }
}

