/*
 * Decompiled with CFR 0.152.
 */
package GreedyExperimentalDesign;

import ExperimentalDesign.MultipleSearchExperimentalDesigns;
import ExperimentalDesign.Tools;
import GreedyExperimentalDesign.GreedySearch;
import java.util.ArrayList;

public class GreedyExperimentalDesign
extends MultipleSearchExperimentalDesigns {
    private boolean diagnostics;
    private boolean semigreedy;
    private Integer max_iters;
    private int[][] starting_indicTs;
    private ArrayList<ArrayList<int[]>> switched_pairs;
    private ArrayList<ArrayList<double[]>> xbardiffjs_by_iterations;
    private ArrayList<ArrayList<Double>> min_obj_val_by_iterations;

    public static void main(String[] stringArray) throws Exception {
        GreedyExperimentalDesign greedyExperimentalDesign = new GreedyExperimentalDesign();
        greedyExperimentalDesign.rand_obj.setSeed(1984L);
        int n = 300;
        int n2 = 5;
        greedyExperimentalDesign.setN(n);
        greedyExperimentalDesign.setP(n2);
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArray[j] = greedyExperimentalDesign.rand_obj.nextDouble();
            }
            greedyExperimentalDesign.setDataRow(i, dArray);
        }
        greedyExperimentalDesign.setMaxDesigns(25);
        greedyExperimentalDesign.setObjective("abs_sum_diff");
        greedyExperimentalDesign.setDiagnostics();
        greedyExperimentalDesign.setWait();
        greedyExperimentalDesign.beginSearch();
    }

    @Override
    public void beginSearch() {
        int n;
        super.beginSearch();
        this.switched_pairs = new ArrayList(this.max_designs);
        for (n = 0; n < this.max_designs; ++n) {
            this.switched_pairs.add(new ArrayList());
        }
        this.xbardiffjs_by_iterations = new ArrayList(this.max_designs);
        for (n = 0; n < this.max_designs; ++n) {
            this.xbardiffjs_by_iterations.add(new ArrayList());
        }
        this.min_obj_val_by_iterations = new ArrayList(this.max_designs);
        for (n = 0; n < this.max_designs; ++n) {
            this.min_obj_val_by_iterations.add(new ArrayList());
        }
        this.initializeStartingIndicTs();
        n = 0;
        while (n < this.max_designs) {
            final int n2 = n++;
            this.search_thread_pool.execute(new Runnable(){

                @Override
                public void run() {
                    new GreedySearch(GreedyExperimentalDesign.this.X, GreedyExperimentalDesign.this.Sinv, GreedyExperimentalDesign.this.Kgram, GreedyExperimentalDesign.this.starting_indicTs[n2], GreedyExperimentalDesign.this.ending_indicTs[n2], GreedyExperimentalDesign.this.switched_pairs.get(n2), GreedyExperimentalDesign.this.min_obj_val_by_iterations.get(n2), GreedyExperimentalDesign.this.xbardiffjs_by_iterations.get(n2), GreedyExperimentalDesign.this.objective_vals, GreedyExperimentalDesign.this.num_iters, GreedyExperimentalDesign.this.objective, n2, GreedyExperimentalDesign.this.semigreedy, GreedyExperimentalDesign.this.diagnostics, GreedyExperimentalDesign.this.max_iters, GreedyExperimentalDesign.this.rand_obj, GreedyExperimentalDesign.this.search_stopped);
                    if (!GreedyExperimentalDesign.this.search_stopped.get()) {
                        GreedyExperimentalDesign.this.num_completed.getAndIncrement();
                    }
                }
            });
        }
        this.afterBeginSearch();
    }

    public int progress() {
        return this.num_completed.get();
    }

    private void initializeStartingIndicTs() {
        this.starting_indicTs = new int[this.max_designs][this.n];
        for (int i = 0; i < this.max_designs; ++i) {
            this.starting_indicTs[i] = Tools.fisherYatesShuffle(Tools.newBalancedBlankDesign(this.n), this.rand_obj);
        }
    }

    public int[][][] getSwitchedPairs(int[] nArray) {
        int[][][] nArrayArray = new int[nArray.length][][];
        for (int i = 0; i < nArray.length; ++i) {
            ArrayList<int[]> arrayList = this.switched_pairs.get(nArray[i]);
            int n = arrayList.size();
            int[][] nArrayArray2 = new int[n][];
            for (int j = 0; j < n; ++j) {
                nArrayArray2[j] = arrayList.get(j);
            }
            nArrayArray[i] = nArrayArray2;
        }
        return nArrayArray;
    }

    public double[][][] getXbarjDiffs(int[] nArray) {
        double[][][] dArrayArray = new double[nArray.length][][];
        for (int i = 0; i < nArray.length; ++i) {
            ArrayList<double[]> arrayList = this.xbardiffjs_by_iterations.get(nArray[i]);
            int n = arrayList.size();
            double[][] dArrayArray2 = new double[n][];
            for (int j = 0; j < n; ++j) {
                dArrayArray2[j] = arrayList.get(j);
            }
            dArrayArray[i] = dArrayArray2;
        }
        return dArrayArray;
    }

    public double[][] getObjValByIter(int[] nArray) {
        double[][] dArrayArray = new double[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            ArrayList<Double> arrayList = this.min_obj_val_by_iterations.get(nArray[i]);
            int n = arrayList.size();
            double[] dArray = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray[j] = arrayList.get(j);
            }
            dArrayArray[i] = dArray;
        }
        return dArrayArray;
    }

    public int[][] getStartingIndicTs(int[] nArray) {
        int[][] nArray2 = new int[nArray.length][this.n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.starting_indicTs[nArray[i]];
        }
        return nArray2;
    }

    public void setDiagnostics() {
        this.diagnostics = true;
    }

    public void setSemigreedy() {
        this.semigreedy = true;
    }

    public void setMaxIters(int n) {
        this.max_iters = n;
    }
}

