/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import org.openfast.ScalarValue;

public class ByteVectorValue
extends ScalarValue {
    private static final long serialVersionUID = 1L;
    public static final ScalarValue EMPTY_BYTES = new ByteVectorValue(new byte[0]);
    public final byte[] value;
    private int offset;
    private int length;

    public ByteVectorValue(byte[] value) {
        this(value, 0, value.length);
    }

    public ByteVectorValue(byte[] value, int offset, int length) {
        this.value = value;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getBytes() {
        return this.value;
    }

    public String serialize() {
        StringBuffer builder = new StringBuffer(this.value.length * 2);
        int i = 0;
        while (i < this.value.length) {
            String hex = Integer.toHexString(this.value[i] & 0xFF);
            if (hex.length() == 1) {
                builder.append('0');
            }
            builder.append(hex);
            ++i;
        }
        return builder.toString();
    }

    public String toString() {
        return new String(this.value, this.offset, this.length);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ByteVectorValue)) {
            return false;
        }
        return this.equals((ByteVectorValue)obj);
    }

    public boolean equals(ByteVectorValue other) {
        if (this.length != other.length) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            if (this.value[this.offset + i] != other.value[other.offset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

