/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf.multivariate;

import ec.benchmarking.ssf.multivariate.Constraint;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.multivariate.AbstractMultivariateSsf;
import java.util.Collection;
import java.util.List;

public class ContemporaneousSsfCholette
extends AbstractMultivariateSsf {
    private int nvars_;
    private double rho_;
    private double[][] w_;
    private Constraint[] constraints_;

    public ContemporaneousSsfCholette(double ro, int nvars) {
        this.nvars_ = nvars;
        this.rho_ = ro;
    }

    public ContemporaneousSsfCholette(double rho, List<double[]> weights) {
        this.rho_ = rho;
        if (weights != null) {
            this.w_ = new double[weights.size()][];
            this.w_ = (double[][])weights.toArray((T[])this.w_);
            this.nvars_ = weights.size();
        }
    }

    public ContemporaneousSsfCholette(double rho, double[][] weights) {
        this.rho_ = rho;
        if (weights != null) {
            this.w_ = weights;
            this.nvars_ = weights.length;
        }
    }

    public double getRho() {
        return this.rho_;
    }

    public void setRho(double rho) {
        this.rho_ = rho;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        qm.diagonal().set(1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return 0;
    }

    @Override
    public int getStateDim() {
        return this.nvars_;
    }

    @Override
    public int getTransitionResCount() {
        return this.nvars_;
    }

    @Override
    public int getTransitionResDim() {
        return this.nvars_;
    }

    @Override
    public int getVarsCount() {
        return this.constraints_.length;
    }

    @Override
    public boolean hasR() {
        return false;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean hasZ(int pos, int v) {
        return true;
    }

    @Override
    public boolean isDiffuse() {
        return false;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.nvars_ > 0 && this.constraints_.length > 0;
    }

    @Override
    public void L(int pos, SubMatrix K, SubMatrix lm) {
        this.T(pos, lm);
        for (int i = 0; i < this.getVarsCount(); ++i) {
            DataBlockIterator rows = lm.rows();
            DataBlock row = rows.getData();
            do {
                double k = -K.get(rows.getPosition(), i);
                this.XpZd(pos, i, row, k);
            } while (rows.next());
        }
    }

    private double mweight(int pos, int v, double m) {
        return this.w_ == null ? m : this.w_[v][pos] * m;
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        pf0.diagonal().set(1.0 / (1.0 - this.rho_ * this.rho_));
    }

    @Override
    public void Pi0(SubMatrix pi0) {
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.diagonal().set(1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
    }

    public void setConstraints(Collection<Constraint> cnt) {
        this.constraints_ = new Constraint[cnt.size()];
        this.constraints_ = cnt.toArray(this.constraints_);
    }

    public void setConstraints(Constraint[] cnt) {
        this.constraints_ = cnt;
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        tr.diagonal().set(this.rho_);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        x.mul(this.rho_);
    }

    @Override
    public void TVT(int pos, SubMatrix V) {
        V.mul(this.rho_ * this.rho_);
    }

    @Override
    public void MT(int pos, SubMatrix M) {
        M.mul(this.rho_);
    }

    @Override
    public void TM(int pos, SubMatrix M) {
        M.mul(this.rho_);
    }

    @Override
    public void VpZdZ(int pos, int v, int w, SubMatrix vm, double d) {
        Constraint vcnt = this.constraints_[v];
        Constraint wcnt = this.constraints_[w];
        for (int i = 0; i < vcnt.index.length; ++i) {
            int k = vcnt.index[i];
            double dk = this.mweight(pos, k, vcnt.weights[i]);
            for (int j = 0; j < wcnt.index.length; ++j) {
                int l = wcnt.index[j];
                double dl = this.mweight(pos, l, wcnt.weights[j]);
                vm.add(k, l, d * dk * dl);
            }
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }

    @Override
    public void XpZd(int pos, int v, DataBlock x, double d) {
        Constraint cnt = this.constraints_[v];
        for (int i = 0; i < cnt.index.length; ++i) {
            int k = cnt.index[i];
            x.add(k, this.mweight(pos, k, cnt.weights[i] * d));
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        x.mul(this.rho_);
    }

    @Override
    public void Z(int pos, int v, DataBlock z) {
        z.set(0.0);
        Constraint cnt = this.constraints_[v];
        for (int i = 0; i < cnt.index.length; ++i) {
            int l = cnt.index[i];
            z.set(l, this.mweight(pos, l, cnt.weights[i]));
        }
    }

    @Override
    public void ZM(int pos, int v, SubMatrix m, DataBlock x) {
        x.set(0.0);
        Constraint cnt = this.constraints_[v];
        for (int i = 0; i < cnt.index.length; ++i) {
            int l = cnt.index[i];
            x.addAY(this.mweight(pos, l, cnt.weights[i]), m.row(l));
        }
    }

    @Override
    public double ZVZ(int pos, int v, int w, SubMatrix vm) {
        Constraint vcnt = this.constraints_[v];
        Constraint wcnt = this.constraints_[w];
        double s = 0.0;
        for (int i = 0; i < vcnt.index.length; ++i) {
            int k = vcnt.index[i];
            double dk = this.mweight(pos, k, vcnt.weights[i]);
            for (int j = 0; j < wcnt.index.length; ++j) {
                int l = wcnt.index[j];
                double dl = this.mweight(pos, l, wcnt.weights[j]);
                s += dk * vm.get(k, l) * dl;
            }
        }
        return s;
    }

    @Override
    public double ZX(int pos, int v, DataBlock x) {
        Constraint cnt = this.constraints_[v];
        double sum = 0.0;
        for (int i = 0; i < cnt.index.length; ++i) {
            int l = cnt.index[i];
            sum += this.mweight(pos, l, x.get(l) * cnt.weights[i]);
        }
        return sum;
    }
}

