/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.dstats;

import ec.tstoolkit.dstats.BoundaryType;
import ec.tstoolkit.dstats.DStatException;
import ec.tstoolkit.dstats.IContinuousDistribution;
import ec.tstoolkit.dstats.ProbInvFinder;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.dstats.SpecialFunctions;
import ec.tstoolkit.random.IRandomNumberGenerator;
import ec.tstoolkit.random.StochasticRandomizer;

public class F
implements IContinuousDistribution {
    private int m_k1 = 1;
    private int m_k2 = 1;

    @Override
    public double getDensity(double x) {
        return SpecialFunctions.FDensity(x, this.m_k1, this.m_k2);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("F with ");
        sb.append(this.m_k1);
        sb.append(" degrees of freedom in the nominator and ");
        sb.append(this.m_k2);
        sb.append(" degrees of freedom in the denominator");
        return sb.toString();
    }

    public int getDFDenom() {
        return this.m_k2;
    }

    public int getDFNum() {
        return this.m_k1;
    }

    @Override
    public double getExpectation() {
        if (this.m_k2 <= 2) {
            throw new DStatException("Expectation undefined for k2 <= 2", "F");
        }
        return (double)this.m_k2 / ((double)this.m_k2 - 2.0);
    }

    @Override
    public double getLeftBound() {
        return 0.0;
    }

    @Override
    public double getProbability(double x, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return 0.0;
        }
        double res = SpecialFunctions.FProbability(x, this.m_k1, this.m_k2);
        if (pt == ProbabilityType.Lower) {
            res = 1.0 - res;
        }
        return res;
    }

    @Override
    public double getProbabilityInverse(double p, ProbabilityType pt) {
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        if (p < 1.0E-15 || 1.0 - p < 1.0E-15) {
            throw new DStatException("Can't compute probability inverse (value is too near 0 or 1)", "F");
        }
        double start = this.m_k2 <= 2 ? 1.0 : (double)this.m_k2 / ((double)this.m_k2 - 2.0);
        return ProbInvFinder.find(p, start, 1.0E-15, 1.0E-9, this);
    }

    @Override
    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVariance() throws DStatException {
        if (this.m_k2 <= 4) {
            throw new DStatException("Variance undefined for k2 <= 4", "F");
        }
        double top = 2 * this.m_k2 * this.m_k2 * (this.m_k1 + this.m_k2 - 2);
        double bot = this.m_k1 * (this.m_k2 - 2) * (this.m_k2 - 2) * (this.m_k2 - 4);
        return top / bot;
    }

    @Override
    public BoundaryType hasLeftBound() {
        return this.m_k1 <= 2 ? BoundaryType.Asymptotical : BoundaryType.Finite;
    }

    @Override
    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    @Override
    public boolean isSymmetrical() {
        return false;
    }

    @Override
    public double random(IRandomNumberGenerator rng) {
        if (rng == null) {
            throw new DStatException("No valid Random Number Generator", "F");
        }
        return StochasticRandomizer.F(rng, this.m_k1, this.m_k2);
    }

    public void setDFDenom(int m_k2) {
        if (m_k2 < 1) {
            throw new DStatException("Degrees of freedom must be larger or equal to 1", "F");
        }
        this.m_k2 = m_k2;
    }

    public void setDFNum(int m_k1) {
        if (m_k1 < 1) {
            throw new DStatException("Degrees of freedom must be larger or equal to 1", "F");
        }
        this.m_k1 = m_k1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("F(");
        sb.append(this.m_k1);
        sb.append(',');
        sb.append(this.m_k2);
        sb.append(')');
        return sb.toString();
    }
}

