/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.AbstractLinearSystemSolver;
import ec.tstoolkit.maths.matrices.IQrDecomposition;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.lapack.Dgeqr2;

public class HouseholderC
extends AbstractLinearSystemSolver
implements IQrDecomposition {
    private double[] m_qr;
    private double[] m_rdiag;
    private int[] m_unused;
    private int m_norig;
    private int m_n;
    private int m_m;
    private boolean m_bclone;

    public HouseholderC(boolean clone) {
        this.m_bclone = clone;
    }

    @Override
    public void decompose(Matrix m) {
        if (this.m_bclone) {
            this.init(m.clone());
        } else {
            this.init(m);
        }
        this.householder();
    }

    @Override
    public void decompose(SubMatrix m) {
        this.init(new Matrix(m));
        this.householder();
    }

    @Override
    public int getEquationsCount() {
        return this.m_m;
    }

    @Override
    public Matrix getR() {
        Matrix r = new Matrix(this.m_n, this.m_n);
        double[] data = r.data_;
        int i = 0;
        int k = 0;
        int l = 0;
        while (i < this.m_n) {
            for (int j = 0; j <= i; ++j) {
                data[k + j] = this.m_qr[l + j];
            }
            ++i;
            k += this.m_n;
            l += this.m_m;
        }
        return r;
    }

    public int getRank() {
        return this.m_n;
    }

    @Override
    public DataBlock getRDiagonal() {
        return new DataBlock(this.m_rdiag);
    }

    @Override
    public int getUnknownsCount() {
        return this.m_norig;
    }

    public int[] getUnused() {
        return this.m_unused;
    }

    private void householder() {
        double[] work = new double[this.m_m];
        this.m_rdiag = new double[this.m_n];
        int info = Dgeqr2.fn(this.m_m, this.m_n, this.m_qr, 0, this.m_m, this.m_rdiag, work);
    }

    private void init(Matrix m) {
        this.m_m = m.getRowsCount();
        this.m_norig = this.m_n = m.getColumnsCount();
        this.m_qr = m.data_;
        this.m_rdiag = new double[this.m_n];
    }

    @Override
    public boolean isFullRank() {
        return this.m_n == this.m_norig;
    }

    @Override
    public void leastSquares(IReadDataBlock x, IDataBlock b, IDataBlock res) throws MatrixException {
        double[] y = new double[x.getLength()];
        x.copyTo(y, 0);
        this.QtB(y);
        if (res != null) {
            res.copyFrom(y, this.m_n);
        }
        for (int k = this.m_n - 1; k >= 0; --k) {
            int n = k;
            y[n] = y[n] / this.m_qr[k * this.m_m + k];
            for (int i = 0; i < k; ++i) {
                int n2 = i;
                y[n2] = y[n2] - y[k] * this.m_qr[i + k * this.m_m];
            }
        }
        b.copyFrom(y, 0);
    }

    public void QB(double[] b) {
        for (int k = this.m_n - 1; k >= 0; --k) {
            int i;
            double s = 0.0;
            for (i = k; i < this.m_m; ++i) {
                s += this.m_qr[k * this.m_m + i] * b[i];
            }
            s = -s / this.m_qr[k * this.m_m + k];
            for (i = k; i < this.m_m; ++i) {
                int n = i;
                b[n] = b[n] + s * this.m_qr[k * this.m_m + i];
            }
        }
    }

    public void QtB(double[] b) {
        int k = 0;
        int km = 0;
        while (k < this.m_n) {
            int i;
            double s = b[k];
            for (i = k + 1; i < this.m_m; ++i) {
                s += this.m_qr[km + i] * b[i];
            }
            s = -s * this.m_rdiag[k];
            int n = k;
            b[n] = b[n] + s;
            for (i = k + 1; i < this.m_m; ++i) {
                int n2 = i;
                b[n2] = b[n2] + s * this.m_qr[km + i];
            }
            ++k;
            km += this.m_m;
        }
    }

    @Override
    public void solve(DataBlock xin, DataBlock xout) throws MatrixException {
        this.leastSquares(xin, xout, null);
    }

    @Override
    public double[] solve(double[] x) {
        if (this.m_norig != this.m_n) {
            throw new MatrixException("m_err_sing");
        }
        double[] b = new double[this.m_n];
        this.leastSquares(new DataBlock(x), new DataBlock(b), null);
        return b;
    }
}

