/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.ElementaryTransformations;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.DiffuseState;
import ec.tstoolkit.ssf.IDiffuseFilteringResults;
import ec.tstoolkit.ssf.IFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.ISsfInitializer;
import ec.tstoolkit.ssf.SsfException;
import ec.tstoolkit.ssf.State;

public class DiffuseSquareRootInitializer
implements ISsfInitializer<ISsf> {
    private ISsf m_ssf;
    private IDiffuseFilteringResults m_frslts;
    private int m_r;
    private boolean m_saveDiffuseVariance = true;
    private boolean m_qinit;
    int[] m_idxR;
    Matrix m_Q;
    Matrix m_WQW;
    Matrix m_W;
    Matrix X_;

    public boolean isSavingDiffuseVariance() {
        return this.m_saveDiffuseVariance;
    }

    public void setSavingDiffuseVariance(boolean save) {
        this.m_saveDiffuseVariance = save;
    }

    private void addQ(int pos, Matrix P) {
        if (!this.m_ssf.hasTransitionRes(pos)) {
            return;
        }
        if (this.m_WQW != null) {
            if (!this.m_ssf.hasR()) {
                P.add(this.m_WQW);
            } else {
                int nr = this.m_idxR.length;
                for (int i = 0; i < nr; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        double w = this.m_WQW.get(i, j);
                        P.add(this.m_idxR[i], this.m_idxR[j], w);
                        if (i == j) continue;
                        P.add(this.m_idxR[j], this.m_idxR[i], w);
                    }
                }
            }
        }
    }

    protected void EPredDiffuse(int pos, ISsfData data, DiffuseState state) {
        this.preArray(pos);
        state.fi = this.X_.row(0).ssq();
        if (state.fi < 1.0E-9) {
            state.fi = 0.0;
            this.X_.row(0).set(0.0);
        }
        state.f = this.m_ssf.ZVZ(pos, state.P.subMatrix());
        if (data.hasData()) {
            double y = data.get(pos);
            if (Double.isNaN(y)) {
                state.e = Double.NaN;
                return;
            }
            state.e = y - this.m_ssf.ZX(pos, state.A);
        }
        this.m_ssf.ZM(pos, state.P.subMatrix(), state.C);
        this.m_ssf.TX(pos, state.C);
        if (state.fi != 0.0) {
            ElementaryTransformations.fastRowGivens(this.X_.subMatrix());
            state.Ci.copy(this.X_.column(0).drop(1, 0));
            state.Ci.mul(this.X_.get(0, 0));
        }
    }

    private boolean getModelInfo(int pos) {
        try {
            if (!this.m_ssf.hasTransitionRes(pos) || this.m_qinit && this.m_ssf.isTransitionEquationTimeInvariant()) {
                return true;
            }
            if (this.m_idxR != null && this.m_ssf.hasR()) {
                SubArrayOfInt R = SubArrayOfInt.create(this.m_idxR);
                R.set(0);
                this.m_ssf.R(pos, R);
            }
            if (this.m_Q != null) {
                this.m_Q.set(0.0);
                this.m_ssf.Q(pos, this.m_Q.subMatrix());
            }
            if (this.m_W != null && this.m_ssf.hasW()) {
                this.m_W.set(0.0);
                this.m_ssf.W(pos, this.m_W.subMatrix());
                SymmetricMatrix.quadraticFormT(this.m_Q.subMatrix(), this.m_W.subMatrix(), this.m_WQW.subMatrix());
                if (this.m_ssf.isTransitionEquationTimeInvariant()) {
                    this.m_qinit = true;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initialize() {
        int rescount = this.m_ssf.getTransitionResCount();
        int resdim = this.m_ssf.getTransitionResDim();
        this.m_qinit = false;
        if (rescount != 0) {
            this.m_Q = new Matrix(resdim, resdim);
            this.m_idxR = (int[])(this.m_ssf.hasR() ? new int[rescount] : null);
            this.m_W = this.m_ssf.hasW() ? new Matrix(rescount, resdim) : null;
            this.m_WQW = this.m_W == null ? this.m_Q : new Matrix(rescount, rescount);
        }
        int d = this.m_ssf.getNonStationaryDim();
        this.X_ = new Matrix(this.m_r + 1, d + 1);
        this.m_ssf.diffuseConstraints(this.X_.subMatrix(1, 1 + this.m_r, 1, 1 + d));
        this.getModelInfo(0);
    }

    @Override
    public int initialize(ISsf ssf, ISsfData data, State state, IFilteringResults rslts) {
        this.m_ssf = ssf;
        this.m_r = ssf.getStateDim();
        this.m_frslts = rslts instanceof IDiffuseFilteringResults ? (IDiffuseFilteringResults)rslts : null;
        this.initialize();
        int pos = 0;
        int end = data.getCount();
        DiffuseState dstate = new DiffuseState(this.m_ssf.getStateDim(), data.hasData());
        this.initState(data, dstate);
        if (this.m_frslts != null) {
            this.m_frslts.prepareDiffuse(this.m_ssf, data);
        }
        if (this.m_ssf.isDiffuse()) {
            do {
                if (!this.m_ssf.isTimeInvariant() && !this.getModelInfo(pos)) {
                    throw new SsfException("Error in diffuse initialization");
                }
                this.EPredDiffuse(pos, data, dstate);
                if (this.m_frslts != null) {
                    this.m_frslts.save(pos, dstate);
                }
                this.nextDiffuse(pos, data, dstate);
            } while (++pos < end && !this.isNull(this.X_.subMatrix(1, this.X_.getRowsCount(), 1, this.X_.getColumnsCount())));
        }
        if (this.m_frslts != null) {
            this.m_frslts.closeDiffuse();
        }
        state.P = dstate.P;
        state.C = dstate.C;
        state.A = dstate.A;
        state.e = dstate.e;
        state.f = dstate.f;
        return pos;
    }

    private void initState(ISsfData data, DiffuseState state) {
        double[] a0 = data.getInitialState();
        if (a0 != null) {
            state.A.copyFrom(a0, 0);
        }
        this.m_ssf.Pf0(state.P.subMatrix());
        this.m_ssf.Pi0(state.Pi.subMatrix());
    }

    private boolean isNull(SubMatrix P) {
        return P.isZero(1.0E-9);
    }

    private void nextDiffuse(int pos, ISsfData data, DiffuseState state) {
        if (state.isMissing() || state.fi == 0.0 && state.f == 0.0) {
            this.nextMissingDiffuse(pos, data, state);
        } else if (state.fi == 0.0) {
            this.nextDiffuse0(pos, data, state);
        } else {
            this.nextDiffuse1(pos, data, state);
        }
        if (this.m_saveDiffuseVariance) {
            SymmetricMatrix.XXt(this.X_.subMatrix(1, this.X_.getRowsCount(), 1, this.X_.getColumnsCount()), state.Pi.subMatrix());
        }
    }

    private void nextDiffuse0(int pos, ISsfData data, DiffuseState state) {
        double c;
        this.m_ssf.TVT(pos, state.P.subMatrix());
        DataBlockIterator cols = state.P.columns();
        DataBlock col = cols.getData();
        int icol = 0;
        do {
            c = -state.C.get(icol) / state.f;
            if (pos > 0) {
                col.drop(icol, 0).addAY(c, state.C.drop(icol, 0));
            } else {
                col.addAY(c, state.C);
            }
            ++icol;
        } while (cols.next());
        SymmetricMatrix.fromLower(state.P);
        this.addQ(pos, state.P);
        if (data.hasData()) {
            this.m_ssf.TX(pos, state.A);
            c = state.e / state.f;
            state.A.addAY(c, state.C);
        }
    }

    private void nextDiffuse1(int pos, ISsfData data, DiffuseState state) {
        double c;
        double f1 = 1.0 / state.fi;
        double f2 = -state.f * f1 * f1;
        this.m_ssf.TVT(pos, state.P.subMatrix());
        DataBlockIterator cols = state.P.columns();
        DataBlock col = cols.getData();
        int icol = 0;
        do {
            c = f2 * state.Ci.get(icol) + f1 * state.C.get(icol);
            if (icol > 0) {
                col.drop(icol, 0).addAY(-c, state.Ci.drop(icol, 0));
            } else {
                col.addAY(-c, state.Ci);
            }
            ++icol;
        } while (cols.next());
        cols.begin();
        icol = 0;
        do {
            c = f1 * state.Ci.get(icol);
            if (icol > 0) {
                col.drop(icol, 0).addAY(-c, state.C.drop(icol, 0));
            } else {
                col.addAY(-c, state.C);
            }
            ++icol;
        } while (cols.next());
        SymmetricMatrix.fromLower(state.P);
        this.addQ(pos, state.P);
        if (data.hasData()) {
            this.m_ssf.TX(pos, state.A);
            double q = f1 * state.e;
            state.A.addAY(q, state.Ci);
        }
    }

    private void nextMissingDiffuse(int pos, ISsfData data, DiffuseState state) {
        this.m_ssf.TVT(pos, state.P.subMatrix());
        this.addQ(pos, state.P);
        this.m_ssf.TX(pos, state.A);
    }

    private void preArray(int pos) {
        int rmax = this.X_.getRowsCount();
        int cmax = this.X_.getColumnsCount();
        DataBlock X = this.X_.row(0).range(1, cmax);
        X.set(0.0);
        this.X_.column(0).set(0.0);
        SubMatrix Y = this.X_.subMatrix(1, rmax, 1, cmax);
        this.m_ssf.ZM(pos, Y, X);
        DataBlockIterator lcols = Y.columns();
        DataBlock lcol = lcols.getData();
        do {
            this.m_ssf.TX(pos, lcol);
        } while (lcols.next());
    }
}

