/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.Utilities;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class LeapYearVariable
extends AbstractSingleTsVariable
implements ILengthOfPeriodVariable {
    private LengthOfPeriodType ltype_ = LengthOfPeriodType.None;

    public LeapYearVariable(LengthOfPeriodType type) {
        this.ltype_ = type;
    }

    public LengthOfPeriodType getType() {
        return this.ltype_;
    }

    public void setType(LengthOfPeriodType ltype) {
        this.ltype_ = ltype;
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        switch (this.ltype_) {
            case LeapYear: {
                Utilities.leapYear(start, data);
                break;
            }
            case LengthOfPeriod: {
                Utilities.lengthofPeriod(start, data);
            }
        }
    }

    @Override
    public String getDescription(TsFrequency context) {
        switch (this.ltype_) {
            case LeapYear: {
                return "Leap year";
            }
            case LengthOfPeriod: {
                return "Length of period";
            }
        }
        return null;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return true;
    }
}

