/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter;
import java.io.PrintWriter;

public class Basic
extends BaseXMLWriter {
    private String space;
    private boolean blockLiterals = false;

    void writeBody(Model model, PrintWriter pw, String base, boolean inclXMLBase) {
        this.space = "";
        for (int i = 0; i < this.tab; ++i) {
            this.space = this.space + " ";
        }
        this.writeRDFHeader(model, pw);
        this.writeRDFStatements(model, pw);
        this.writeRDFTrailer(pw, base);
        pw.flush();
    }

    protected void writeSpace(PrintWriter writer) {
        writer.print(this.space);
    }

    private void writeRDFHeader(Model model, PrintWriter writer) {
        String xmlns = this.xmlnsDecl();
        writer.print("<" + this.rdfEl("RDF") + xmlns);
        if (null != this.xmlBase && this.xmlBase.length() > 0) {
            writer.print("\n  xml:base=" + this.qq(this.xmlBase));
        }
        writer.println(" >");
    }

    protected void writeRDFStatements(Model model, PrintWriter writer) {
        ResIterator rIter = model.listSubjects();
        while (rIter.hasNext()) {
            this.writeRDFStatements(model, rIter.nextResource(), writer);
        }
    }

    protected void writeRDFTrailer(PrintWriter writer, String base) {
        writer.println("</" + this.rdfEl("RDF") + ">");
    }

    protected void writeRDFStatements(Model model, Resource subject, PrintWriter writer) {
        StmtIterator sIter = model.listStatements(subject, null, (RDFNode)null);
        this.writeDescriptionHeader(subject, writer);
        while (sIter.hasNext()) {
            this.writePredicate(sIter.nextStatement(), writer);
        }
        this.writeDescriptionTrailer(subject, writer);
    }

    protected void writeDescriptionHeader(Resource subject, PrintWriter writer) {
        writer.print(this.space + "<" + this.rdfEl("Description") + " ");
        this.writeResourceId(subject, writer);
        writer.println(">");
    }

    protected void writePredicate(Statement stmt, PrintWriter writer) {
        Property predicate = stmt.getPredicate();
        RDFNode object = stmt.getObject();
        writer.print(this.space + this.space + "<" + this.startElementTag(predicate.getNameSpace(), predicate.getLocalName()));
        if (object instanceof Resource) {
            writer.print(" ");
            this.writeResourceReference((Resource)object, writer);
            writer.println("/>");
        } else {
            this.writeLiteral((Literal)object, writer);
            writer.println("</" + this.endElementTag(predicate.getNameSpace(), predicate.getLocalName()) + ">");
        }
    }

    void unblockAll() {
        this.blockLiterals = false;
    }

    void blockRule(Resource r) {
        if (((Object)r).equals(RDFSyntax.parseTypeLiteralPropertyElt)) {
            this.blockLiterals = true;
        } else {
            logger.warn("Cannot block rule <" + r.getURI() + ">");
        }
    }

    protected void writeDescriptionTrailer(Resource subject, PrintWriter writer) {
        writer.println(this.space + "</" + this.rdfEl("Description") + ">");
    }

    protected void writeDescriptionTrailer(PrintWriter writer) {
        this.writeDescriptionTrailer(null, writer);
    }

    protected void writeResourceId(Resource r, PrintWriter writer) {
        if (r.isAnon()) {
            writer.print(this.rdfAt("nodeID") + "=" + this.q(this.anonId(r)));
        } else {
            writer.print(this.rdfAt("about") + "=" + this.qq(this.relativize(r.getURI())));
        }
    }

    protected void writeResourceReference(Resource r, PrintWriter writer) {
        if (r.isAnon()) {
            writer.print(this.rdfAt("nodeID") + "=" + this.q(this.anonId(r)));
        } else {
            writer.print(this.rdfAt("resource") + "=" + this.qq(this.relativize(r.getURI())));
        }
    }

    protected void writeLiteral(Literal l, PrintWriter writer) {
        String lang = l.getLanguage();
        String form = l.getLexicalForm();
        if (!lang.equals("")) {
            writer.print(" xml:lang=" + this.q(lang));
        }
        if (l.isWellFormedXML() && !this.blockLiterals) {
            writer.print(" " + this.rdfAt("parseType") + "=" + this.q("Literal") + ">");
            writer.print(form);
        } else {
            String dt = l.getDatatypeURI();
            if (dt != null) {
                writer.print(" " + this.rdfAt("datatype") + "=" + this.qq(dt));
            }
            writer.print(">");
            writer.print(Util.substituteEntitiesInElementContent(form));
        }
    }
}

