/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.io.Serializable;
import weka.core.Instance;

public class Coordinates
implements Serializable {
    private static final long serialVersionUID = 2319016195345994738L;
    private int[] m_coord;
    private int m_hashCode;

    public Coordinates(Instance instance) {
        double[] dArray = instance.toDoubleArray();
        int n = instance.classIndex();
        this.m_coord = n == -1 ? new int[dArray.length] : new int[dArray.length - 1];
        this.m_hashCode = 0;
        int n2 = 1;
        int n3 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (i == n) continue;
            this.m_coord[n3] = (int)dArray[i];
            if (i > 0 && i - 1 != n) {
                n2 *= instance.attribute(i - 1).numValues();
            } else if (i - 1 == n && n != -1 && n != 0) {
                n2 *= instance.attribute(i - 2).numValues();
            }
            this.m_hashCode += this.m_coord[n3] * n2;
            ++n3;
        }
    }

    public double getValue(int n) {
        return this.m_coord[n];
    }

    public void getValues(double[] dArray) {
        for (int i = 0; i < this.m_coord.length; ++i) {
            dArray[i] = this.m_coord[i];
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Coordinates)) {
            return false;
        }
        Coordinates coordinates = (Coordinates)object;
        if (this.m_coord.length != coordinates.m_coord.length || this.m_hashCode != coordinates.m_hashCode) {
            return false;
        }
        for (int i = 0; i < this.m_coord.length; ++i) {
            if (this.m_coord[i] == coordinates.m_coord[i]) continue;
            return false;
        }
        return true;
    }

    public boolean strictlySmaller(Coordinates coordinates) throws IllegalArgumentException {
        int n;
        if (coordinates.m_coord.length != this.m_coord.length) {
            throw new IllegalArgumentException("Coordinates are not from the same space");
        }
        for (n = 0; n < this.m_coord.length && coordinates.m_coord[n] == this.m_coord[n]; ++n) {
        }
        if (n == this.m_coord.length) {
            return false;
        }
        while (n < this.m_coord.length) {
            if (this.m_coord[n] > coordinates.m_coord[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean smallerOrEqual(Coordinates coordinates) throws IllegalArgumentException {
        if (coordinates.m_coord.length != this.m_coord.length) {
            throw new IllegalArgumentException("Coordinates are not from the same space");
        }
        for (int i = 0; i < this.m_coord.length; ++i) {
            if (this.m_coord[i] <= coordinates.m_coord[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public int dimension() {
        return this.m_coord.length;
    }

    public String toString() {
        String string = "(";
        for (int i = 0; i < this.m_coord.length - 1; ++i) {
            string = string + this.m_coord[i] + ",";
        }
        return string + this.m_coord[this.m_coord.length - 1] + ")";
    }
}

