/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.simplecli;

import java.util.ArrayList;
import java.util.List;
import weka.gui.simplecli.AbstractCommand;

public class Help
extends AbstractCommand {
    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getHelp() {
        return "Outputs the help for the specified command or, if omitted,\nfor all commands.";
    }

    @Override
    public String getParameterHelp() {
        return "[command1] [command2] [...]";
    }

    @Override
    protected void doExecute(String[] params) throws Exception {
        boolean all = false;
        List<AbstractCommand> cmds = Help.getCommands();
        ArrayList<AbstractCommand> help = new ArrayList<AbstractCommand>();
        int n = 0;
        String[] stringArray = params;
        int n2 = stringArray.length;
        if (n < n2) {
            String param = stringArray[n];
            AbstractCommand cmd = Help.getCommand(param);
            if (cmd != null) {
                help.add(cmd);
            } else {
                throw new Exception("Unknown command: " + param);
            }
        }
        if (help.isEmpty()) {
            all = true;
            help.addAll(cmds);
        }
        for (AbstractCommand c : help) {
            String[] lines;
            System.out.println(c.getName() + (c.getParameterHelp().isEmpty() ? "" : " " + c.getParameterHelp()));
            for (String line : lines = c.getHelp().split("\n")) {
                System.out.println("\t" + line);
            }
            System.out.println();
        }
        if (all) {
            System.out.println("\nNotes:");
            System.out.println("- Variables can be used anywhere using '${<name>}' with '<name>'");
            System.out.println("  being the name of the variable.");
            System.out.println("- Environment variables can be used with '${env.<name>}', ");
            System.out.println("  e.g., '${env.PATH}' to retrieve the PATH variable.");
        }
    }
}

