/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.EmptyObjectSinkAdapter;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;

public abstract class ObjectSource
extends BaseNode
implements Externalizable {
    protected ObjectSinkPropagator sink;
    protected ObjectSource source;
    private int alphaNodeHashingThreshold;
    protected BitMask declaredMask = EmptyBitMask.get();
    protected BitMask inferredMask = EmptyBitMask.get();

    public ObjectSource() {
    }

    ObjectSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this(id, partitionId, partitionsEnabled, null, 3);
    }

    ObjectSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, ObjectSource objectSource, int alphaNodeHashingThreshold) {
        super(id, partitionId, partitionsEnabled);
        this.source = objectSource;
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
        this.sink = EmptyObjectSinkAdapter.getInstance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (ObjectSinkPropagator)in.readObject();
        this.source = (ObjectSource)in.readObject();
        this.alphaNodeHashingThreshold = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
        out.writeObject(this.source);
        out.writeInt(this.alphaNodeHashingThreshold);
    }

    public ObjectSource getParentObjectSource() {
        return this.source;
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        return this.source.getKnowledgeBase();
    }

    public void initDeclaredMask(BuildContext context) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.declaredMask = AllSetBitMask.get();
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            this.declaredMask = AllSetBitMask.get();
            return;
        }
        Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
        TypeDeclaration typeDeclaration = context.getKnowledgeBase().getTypeDeclaration(objectClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertyReactive()) {
            this.declaredMask = AllSetBitMask.get();
        } else {
            List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getKnowledgeBase(), objectClass);
            this.declaredMask = this.calculateDeclaredMask(settableProperties);
        }
    }

    public abstract BitMask calculateDeclaredMask(List<String> var1);

    public void resetInferredMask() {
        this.inferredMask = EmptyBitMask.get();
    }

    public BitMask updateMask(BitMask mask) {
        BitMask returnMask = this.source.getType() != 30 ? this.source.updateMask(this.declaredMask.clone().setAll(mask)) : this.declaredMask.clone().setAll(mask);
        this.inferredMask = this.inferredMask.setAll(returnMask);
        return returnMask;
    }

    public void addObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            this.sink = new SingleObjectSinkAdapter(this.getPartitionId(), objectSink);
        } else if (this.sink instanceof SingleObjectSinkAdapter) {
            CompositeObjectSinkAdapter sinkAdapter = new CompositeObjectSinkAdapter(this.getPartitionId(), this.alphaNodeHashingThreshold);
            sinkAdapter.addObjectSink(this.sink.getSinks()[0]);
            sinkAdapter.addObjectSink(objectSink);
            this.sink = sinkAdapter;
        } else {
            ((CompositeObjectSinkAdapter)this.sink).addObjectSink(objectSink);
        }
    }

    public boolean removeObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleObjectSinkAdapter) {
            this.sink = EmptyObjectSinkAdapter.getInstance();
        } else {
            CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)this.sink;
            sinkAdapter.removeObjectSink(objectSink);
            if (sinkAdapter.size() == 1) {
                this.sink = new SingleObjectSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]);
            }
        }
        return true;
    }

    public abstract void updateSink(ObjectSink var1, PropagationContext var2, InternalWorkingMemory var3);

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.source.networkUpdated(updateContext);
    }

    public ObjectSinkPropagator getObjectSinkPropagator() {
        return this.sink;
    }

    @Override
    public boolean isInUse() {
        return this.sink.size() > 0;
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!context.getKnowledgeBase().getConfiguration().isPhreakEnabled() && !this.isInUse() && this instanceof MemoryFactory) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory((MemoryFactory)((Object)this));
            }
        }
        if (!this.isInUse() && this instanceof ObjectSink) {
            this.source.removeObjectSink((ObjectSink)((Object)this));
            return true;
        }
        return false;
    }

    protected ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this;
        while (source != null) {
            if (source.getType() == 30) {
                return (ObjectTypeNode)source;
            }
            source = source.source;
        }
        return null;
    }

    public BitMask getDeclaredMask() {
        return EmptyBitMask.get();
    }
}

