/*
 * Decompiled with CFR 0.152.
 */
package edu.dtulnu.stat.brpts.rect;

public class MinMaxRangeTree {
    private int leftMin;
    private int rightMax;
    private int tailLength;
    private int nodecount;
    private double[] data;
    private Node root;

    public MinMaxRangeTree(double[] data) {
        this.data = data;
        this.leftMin = 0;
        this.rightMax = data.length - 1;
        this.buildDS();
    }

    private void buildDS() {
        this.nodecount = 0;
        this.root = this.recurseNodes(this.leftMin, this.rightMax);
    }

    public double[] getResult(int l, int r) {
        Node currNode = this.root;
        if (l > r) {
            return null;
        }
        return this.recursiveGet(this.root, l, r);
    }

    private double[] recursiveGet(Node currNode, int l, int r) {
        if (r < currNode.left || l > currNode.right) {
            System.out.println("RangeTree: Error query range disjoint from node range");
            return null;
        }
        if (l <= currNode.left && currNode.right <= r) {
            return currNode.getMinMax();
        }
        int middle = (currNode.left + currNode.right) / 2;
        if (r <= middle) {
            return this.recursiveGet(currNode.leftChild, l, r);
        }
        if (middle < l) {
            return this.recursiveGet(currNode.rightChild, l, r);
        }
        double[] a1 = this.recursiveGet(currNode.leftChild, l, middle);
        double[] a2 = this.recursiveGet(currNode.rightChild, middle + 1, r);
        double[] merged = new double[]{Math.min(a1[0], a2[0]), Math.max(a1[1], a2[1])};
        return merged;
    }

    private Node recurseNodes(int l, int r) {
        ++this.nodecount;
        if (l == r) {
            Node nn = new Node(l, r, this.data[l], this.data[r]);
            return nn;
        }
        Node ln = this.recurseNodes(l, (r + l) / 2);
        Node rn = this.recurseNodes((l + r) / 2 + 1, r);
        Node nn = new Node(l, r, Math.min(ln.min, rn.min), Math.max(ln.max, rn.max));
        nn.leftChild = ln;
        nn.rightChild = rn;
        return nn;
    }

    public int getNoOfNodes() {
        return this.nodecount;
    }

    class Node {
        int left;
        int right;
        double min;
        double max;
        Node leftChild;
        Node rightChild;

        public Node(int left, int right, double min, double max) {
            this.left = left;
            this.right = right;
            this.min = min;
            this.max = max;
        }

        public double[] getMinMax() {
            return new double[]{this.min, this.max};
        }

        public String toString() {
            return "Node: [" + this.left + ";" + this.right + "] " + this.min + " " + this.max;
        }
    }
}

