## ----setup, include=FALSE------------------------------------------------
library(knitr)
library(XNomial)
version <- packageDescription("XNomial", fields = "Version")
opts_chunk$set(fig.width=8, fig.height=5)
set.seed(60823316) 

## ----peasF2--------------------------------------------------------------
peasF2 <- c(315, 108, 101, 32)
getwd()

## ----peasExp-------------------------------------------------------------
peasExp <- c(9, 3, 3, 1)

## ----call1---------------------------------------------------------------
xmulti(peasF2, peasExp)

## ----call2---------------------------------------------------------------
xmulti(peasF2, peasExp, detail=3)

## ----peaPlot-------------------------------------------------------------
xmulti(peasF2, peasExp, histobins=T)

## ----rePeas--------------------------------------------------------------
rePeas <- c(230, 85, 108, 80, 21, 32)

## ----reExp---------------------------------------------------------------
reExp <- c(6,3,3,2,1,1)

## ----callMonte-----------------------------------------------------------
xmonte(rePeas, reExp)

## ----plotMonte-----------------------------------------------------------
xmonte(rePeas, reExp, detail=3, histobins=T)

## ----obsMut--------------------------------------------------------------
obsMut <- c(84, 11, 4, 1)

## ----probMut-------------------------------------------------------------
probMut <- dpois(0:2, 0.2);
probMut[4] <- 1 - sum(probMut); 

## ----plotMut-------------------------------------------------------------
xmulti(obsMut, probMut, detail=3, histobins=T)

