## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----use-examples--------------------------------------------------------
ibmsunburst::ibmsunburst(system.file(
  "extdata", "profiles",
  "en_v2.json", package = "ibmsunburst"
),
                           version = "v2")

ibmsunburst::ibmsunburst(system.file(
  "extdata", "profiles",
  "en_v3.json", package = "ibmsunburst"
),
                           version = "v3")


## ----echo=FALSE----------------------------------------------------------
insightdata <- list(word_count = 1367L, processed_language = "en", personality = list(
    list(trait_id = "big5_openness", name = "Openness", category = "personality", 
        percentile = 0.996943724028395, significant = TRUE, children = list(
            list(trait_id = "facet_adventurousness", name = "Adventurousness", 
                category = "personality", percentile = 0.785443558667659, 
                significant = TRUE), list(trait_id = "facet_artistic_interests", 
                name = "Artistic interests", category = "personality", 
                percentile = 0.994587051044923, significant = TRUE), 
            list(trait_id = "facet_emotionality", name = "Emotionality", 
                category = "personality", percentile = 0.76755648249161, 
                significant = TRUE), list(trait_id = "facet_imagination", 
                name = "Imagination", category = "personality", 
                percentile = 0.312264713851739, significant = TRUE), 
            list(trait_id = "facet_intellect", name = "Intellect", 
                category = "personality", percentile = 0.996461494123912, 
                significant = TRUE), list(trait_id = "facet_liberalism", 
                name = "Authority-challenging", category = "personality", 
                percentile = 0.795118317664039, significant = TRUE))), 
    list(trait_id = "big5_conscientiousness", name = "Conscientiousness", 
        category = "personality", percentile = 0.987005146423461, 
        significant = TRUE, children = list(list(trait_id = "facet_achievement_striving", 
            name = "Achievement striving", category = "personality", 
            percentile = 0.840226001947556, significant = TRUE), 
            list(trait_id = "facet_cautiousness", name = "Cautiousness", 
                category = "personality", percentile = 0.94520947572947, 
                significant = TRUE), list(trait_id = "facet_dutifulness", 
                name = "Dutifulness", category = "personality", 
                percentile = 0.797168240855955, significant = TRUE), 
            list(trait_id = "facet_orderliness", name = "Orderliness", 
                category = "personality", percentile = 0.763130689698473, 
                significant = TRUE), list(trait_id = "facet_self_discipline", 
                name = "Self-discipline", category = "personality", 
                percentile = 0.714893021903183, significant = TRUE), 
            list(trait_id = "facet_self_efficacy", name = "Self-efficacy", 
                category = "personality", percentile = 0.697220601738676, 
                significant = TRUE))), list(trait_id = "big5_extraversion", 
        name = "Extraversion", category = "personality", percentile = 0.0812673040803595, 
        significant = TRUE, children = list(list(trait_id = "facet_activity_level", 
            name = "Activity level", category = "personality", 
            percentile = 0.961921957562855, significant = TRUE), 
            list(trait_id = "facet_assertiveness", name = "Assertiveness", 
                category = "personality", percentile = 0.919087674799881, 
                significant = TRUE), list(trait_id = "facet_cheerfulness", 
                name = "Cheerfulness", category = "personality", 
                percentile = 0.22949731316403, significant = TRUE), 
            list(trait_id = "facet_excitement_seeking", name = "Excitement-seeking", 
                category = "personality", percentile = 0.210638204016778, 
                significant = TRUE), list(trait_id = "facet_friendliness", 
                name = "Outgoing", category = "personality", 
                percentile = 0.705666969810049, significant = TRUE), 
            list(trait_id = "facet_gregariousness", name = "Gregariousness", 
                category = "personality", percentile = 0.221438987186917, 
                significant = TRUE))), list(trait_id = "big5_agreeableness", 
        name = "Agreeableness", category = "personality", percentile = 0.189345596292676, 
        significant = TRUE, children = list(list(trait_id = "facet_altruism", 
            name = "Altruism", category = "personality", percentile = 0.971398259858467, 
            significant = TRUE), list(trait_id = "facet_cooperation", 
            name = "Cooperation", category = "personality", percentile = 0.822012812195996, 
            significant = TRUE), list(trait_id = "facet_modesty", 
            name = "Modesty", category = "personality", percentile = 0.765562739654055, 
            significant = TRUE), list(trait_id = "facet_morality", 
            name = "Uncompromising", category = "personality", 
            percentile = 0.947660024697345, significant = TRUE), 
            list(trait_id = "facet_sympathy", name = "Sympathy", 
                category = "personality", percentile = 0.999090206524463, 
                significant = TRUE), list(trait_id = "facet_trust", 
                name = "Trust", category = "personality", percentile = 0.828176107542339, 
                significant = TRUE))), list(trait_id = "big5_neuroticism", 
        name = "Emotional range", category = "personality", percentile = 0.944973989307574, 
        significant = TRUE, children = list(list(trait_id = "facet_anger", 
            name = "Fiery", category = "personality", percentile = 0.0142773913194722, 
            significant = TRUE), list(trait_id = "facet_anxiety", 
            name = "Prone to worry", category = "personality", 
            percentile = 0.0624269755012226, significant = TRUE), 
            list(trait_id = "facet_depression", name = "Melancholy", 
                category = "personality", percentile = 0.354216307589723, 
                significant = TRUE), list(trait_id = "facet_immoderation", 
                name = "Immoderation", category = "personality", 
                percentile = 0.0111134702076494, significant = TRUE), 
            list(trait_id = "facet_self_consciousness", name = "Self-consciousness", 
                category = "personality", percentile = 0.19769827428, 
                significant = TRUE), list(trait_id = "facet_vulnerability", 
                name = "Susceptible to stress", category = "personality", 
                percentile = 0.0711117659672653, significant = TRUE)))), 
    needs = list(list(trait_id = "need_challenge", name = "Challenge", 
        category = "needs", percentile = 0.00323067052440407, 
        significant = TRUE), list(trait_id = "need_closeness", 
        name = "Closeness", category = "needs", percentile = 0.369171300274383, 
        significant = TRUE), list(trait_id = "need_curiosity", 
        name = "Curiosity", category = "needs", percentile = 0.848693866377943, 
        significant = TRUE), list(trait_id = "need_excitement", 
        name = "Excitement", category = "needs", percentile = 0.115143383628372, 
        significant = TRUE), list(trait_id = "need_harmony", 
        name = "Harmony", category = "needs", percentile = 0.470315343866337, 
        significant = TRUE), list(trait_id = "need_ideal", name = "Ideal", 
        category = "needs", percentile = 0.0238218325571435, 
        significant = TRUE), list(trait_id = "need_liberty", 
        name = "Liberty", category = "needs", percentile = 0.109333434706629, 
        significant = TRUE), list(trait_id = "need_love", name = "Love", 
        category = "needs", percentile = 0.0118455106849552, 
        significant = TRUE), list(trait_id = "need_practicality", 
        name = "Practicality", category = "needs", percentile = 0.0190624787232559, 
        significant = TRUE), list(trait_id = "need_self_expression", 
        name = "Self-expression", category = "needs", percentile = 0.185177146506239, 
        significant = TRUE), list(trait_id = "need_stability", 
        name = "Stability", category = "needs", percentile = 0.401929984925831, 
        significant = TRUE), list(trait_id = "need_structure", 
        name = "Structure", category = "needs", percentile = 0.890868560456619, 
        significant = TRUE)), values = list(list(trait_id = "value_conservation", 
        name = "Conservation", category = "values", percentile = 0.51625249059153, 
        significant = TRUE), list(trait_id = "value_openness_to_change", 
        name = "Openness to change", category = "values", percentile = 0.622535290077671, 
        significant = TRUE), list(trait_id = "value_hedonism", 
        name = "Hedonism", category = "values", percentile = 0.00518178665341018, 
        significant = TRUE), list(trait_id = "value_self_enhancement", 
        name = "Self-enhancement", category = "values", percentile = 0.00121154980290994, 
        significant = TRUE), list(trait_id = "value_self_transcendence", 
        name = "Self-transcendence", category = "values", percentile = 0.3449575740568, 
        significant = TRUE)), warnings = list())
insightdata <- jsonlite::toJSON(
       insightdata,
       auto_unbox = TRUE
    )


## ------------------------------------------------------------------------
ibmsunburst::ibmsunburst(insightdata,
                         version = "v3")


