/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.filters;

import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class ElementFilter
extends XMLFilterImpl {
    private String namespaceURI = null;
    private String localName = null;

    public ElementFilter(String localName) {
        this(Version.PMML_4_4.getNamespaceURI(), localName);
    }

    public ElementFilter(String namespaceURI, String localName) {
        this.setNamespaceURI(namespaceURI);
        this.setLocalName(localName);
    }

    public ElementFilter(Class<? extends PMMLObject> clazz) {
        XmlRootElement element = ElementFilter.getElement(clazz);
        this.setNamespaceURI(element.namespace());
        this.setLocalName(element.name());
    }

    public ElementFilter(XMLReader reader, String localName) {
        this(reader, Version.PMML_4_4.getNamespaceURI(), localName);
    }

    public ElementFilter(XMLReader reader, String namespaceURI, String localName) {
        super(reader);
        this.setNamespaceURI(namespaceURI);
        this.setLocalName(localName);
    }

    public ElementFilter(XMLReader reader, Class<? extends PMMLObject> clazz) {
        super(reader);
        XmlRootElement element = ElementFilter.getElement(clazz);
        this.setNamespaceURI(element.namespace());
        this.setLocalName(element.name());
    }

    public boolean matches(String namespaceURI, String localName) {
        return ElementFilter.equals(this.getNamespaceURI(), namespaceURI) && ElementFilter.equals(this.getLocalName(), localName);
    }

    public String getQualifiedName() {
        String namespaceURI = this.getNamespaceURI();
        String localName = this.getLocalName();
        if (!"*".equals(namespaceURI) && !"*".equals(localName)) {
            return namespaceURI + ":" + localName;
        }
        return localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    private void setNamespaceURI(String namespaceURI) {
        if (namespaceURI == null) {
            throw new NullPointerException();
        }
        this.namespaceURI = namespaceURI;
    }

    public String getLocalName() {
        return this.localName;
    }

    private void setLocalName(String localName) {
        if (localName == null) {
            throw new NullPointerException();
        }
        this.localName = localName;
    }

    private static XmlRootElement getElement(Class<? extends PMMLObject> clazz) {
        XmlRootElement result = clazz.getAnnotation(XmlRootElement.class);
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static boolean equals(String left, String right) {
        return Objects.equals(left, right) || Objects.equals(left, "*");
    }
}

