/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.time;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.__builtin__;
import org.python.modules.time.PyTimeTuple;
import org.python.modules.time.TimeFunctions;

public class Time
implements ClassDictInit {
    public static PyString __doc__ = new PyString("This module provides various functions to manipulate time values.\n\nThere are two standard representations of time.  One is the number\nof seconds since the Epoch, in UTC (a.k.a. GMT).  It may be an integer\nor a floating point number (to represent fractions of seconds).\nThe Epoch is system-defined; on Unix, it is generally January 1st, 1970.\nThe actual value can be retrieved by calling gmtime(0).\n\nThe other representation is a tuple of 9 integers giving local time.\nThe tuple items are:\n  year (four digits, e.g. 1998)\n  month (1-12)\n  day (1-31)\n  hours (0-23)\n  minutes (0-59)\n  seconds (0-59)\n  weekday (0-6, Monday is 0)\n  Julian day (day in the year, 1-366)\n  DST (Daylight Savings Time) flag (-1, 0 or 1)\nIf the DST flag is 0, the time is given in the regular time zone;\nif it is 1, the time is given in the DST time zone;\nif it is -1, mktime() should guess based on the date and time.\n\nVariables:\n\ntimezone -- difference in seconds between UTC and local standard time\naltzone -- difference in  seconds between UTC and local DST time\ndaylight -- whether local time should reflect DST\ntzname -- tuple of (standard time zone name, DST time zone name)\n\nFunctions:\n\ntime() -- return current time in seconds since the Epoch as a float\nclock() -- return CPU time since process start as a float\nsleep() -- delay for a number of seconds given as a float\ngmtime() -- convert seconds since Epoch to UTC tuple\nlocaltime() -- convert seconds since Epoch to local time tuple\nasctime() -- convert time tuple to string\nctime() -- convert time in seconds to string\nmktime() -- convert local time tuple to seconds since Epoch\nstrftime() -- convert time tuple to string according to format specification\nstrptime() -- parse string to time tuple according to format specification\n");
    private static final double NANOS_PER_SECOND = 1.0E9;
    private static long initialClock;
    private static volatile boolean clockInitialized;
    protected static Locale currentLocale;
    protected static DateFormatSymbols datesyms;
    protected static String[] shortdays;
    protected static String[] shortmonths;
    private static String[] enshortdays;
    private static String[] enshortmonths;
    public static int timezone;
    public static int altzone;
    public static int daylight;
    public static PyTuple tzname;
    public static final int accept2dyear = 0;
    private static final String DEFAULT_FORMAT_PY = "%a %b %d %H:%M:%S %Y";
    private static final HashMap<Character, String> py2java;
    private static final List<Character> notSupported;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("time", (PyObject)new TimeFunctions("time", 0, 0));
        dict.__setitem__("clock", (PyObject)new TimeFunctions("clock", 1, 0));
        dict.__setitem__("struct_time", (PyObject)PyTimeTuple.TYPE);
        dict.__setitem__("__name__", (PyObject)Py.newString("time"));
        TimeZone tz = TimeZone.getDefault();
        tzname = new PyTuple(new PyString(tz.getDisplayName(false, 0)), new PyString(tz.getDisplayName(true, 0)));
        daylight = tz.useDaylightTime() ? 1 : 0;
        timezone = -tz.getRawOffset() / 1000;
        altzone = timezone - tz.getDSTSavings() / 1000;
    }

    public static double time() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double clock() {
        if (!clockInitialized) {
            initialClock = System.nanoTime();
            clockInitialized = true;
            return 0.0;
        }
        return (double)(System.nanoTime() - initialClock) / 1.0E9;
    }

    private static void throwValueError(String msg) {
        throw new PyException(Py.ValueError, new PyString(msg));
    }

    private static int item(PyTuple tup, int i) {
        int val = tup.__getitem__(i).asInt();
        boolean valid = true;
        switch (i) {
            case 0: {
                break;
            }
            case 1: {
                valid = 0 <= val && val <= 12;
                break;
            }
            case 2: {
                valid = 0 <= val && val <= 31;
                break;
            }
            case 3: {
                valid = 0 <= val && val <= 23;
                break;
            }
            case 4: {
                valid = 0 <= val && val <= 59;
                break;
            }
            case 5: {
                valid = 0 <= val && val <= 61;
                break;
            }
            case 6: {
                valid = 0 <= val && val <= 6;
                break;
            }
            case 7: {
                valid = 0 <= val && val < 367;
                break;
            }
            case 8: {
                boolean bl = valid = -1 <= val && val <= 1;
            }
        }
        if (!valid) {
            String msg;
            switch (i) {
                case 1: {
                    msg = "month out of range (1-12)";
                    break;
                }
                case 2: {
                    msg = "day out of range (1-31)";
                    break;
                }
                case 3: {
                    msg = "hour out of range (0-23)";
                    break;
                }
                case 4: {
                    msg = "minute out of range (0-59)";
                    break;
                }
                case 5: {
                    msg = "second out of range (0-59)";
                    break;
                }
                case 6: {
                    msg = "day of week out of range (0-6)";
                    break;
                }
                case 7: {
                    msg = "day of year out of range (1-366)";
                    break;
                }
                case 8: {
                    msg = "daylight savings flag out of range (-1,0,1)";
                    break;
                }
                default: {
                    msg = "ignore";
                }
            }
            Time.throwValueError(msg);
        }
        switch (i) {
            case 1: {
                if (val <= 0) break;
                --val;
                break;
            }
            case 2: 
            case 7: {
                if (val != 0) break;
                val = 1;
            }
        }
        return val;
    }

    private static GregorianCalendar _tupletocal(PyTuple tup) {
        return new GregorianCalendar(Time.item(tup, 0), Time.item(tup, 1), Time.item(tup, 2), Time.item(tup, 3), Time.item(tup, 4), Time.item(tup, 5));
    }

    public static double mktime(PyTuple tup) {
        GregorianCalendar cal;
        try {
            cal = Time._tupletocal(tup);
        }
        catch (PyException e) {
            e.type = Py.OverflowError;
            throw e;
        }
        int dst = Time.item(tup, 8);
        if (dst == 0 || dst == 1) {
            cal.set(16, dst * cal.getTimeZone().getDSTSavings());
        }
        return (double)cal.getTime().getTime() / 1000.0;
    }

    protected static PyTimeTuple _timefields(double secs, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.clear();
        if ((secs *= 1000.0) < -9.223372036854776E18 || secs > 9.223372036854776E18) {
            throw Py.ValueError("timestamp out of range for platform time_t");
        }
        cal.setTime(new Date((long)secs));
        int dow = cal.get(7) - 2;
        if (dow < 0) {
            dow += 7;
        }
        boolean isdst = tz.inDaylightTime(cal.getTime());
        return new PyTimeTuple(new PyInteger(cal.get(1)), new PyInteger(cal.get(2) + 1), new PyInteger(cal.get(5)), new PyInteger(cal.get(10) + 12 * cal.get(9)), new PyInteger(cal.get(12)), new PyInteger(cal.get(13)), new PyInteger(dow), new PyInteger(cal.get(6)), new PyInteger(isdst ? 1 : 0));
    }

    public static double parseTimeDoubleArg(PyObject arg) {
        if (arg == Py.None) {
            return Time.time();
        }
        Object result = arg.__tojava__(Double.class);
        if (result == Py.NoConversion) {
            throw Py.TypeError("a float is required");
        }
        return (Double)result;
    }

    public static PyTuple localtime() {
        return Time.localtime(Py.None);
    }

    public static PyTuple localtime(PyObject secs) {
        return Time._timefields(Time.parseTimeDoubleArg(secs), TimeZone.getDefault());
    }

    public static PyTuple gmtime() {
        return Time.gmtime(Py.None);
    }

    public static PyTuple gmtime(PyObject arg) {
        return Time._timefields(Time.parseTimeDoubleArg(arg), TimeZone.getTimeZone("GMT"));
    }

    public static PyString ctime() {
        return Time.ctime(Py.None);
    }

    public static PyString ctime(PyObject secs) {
        return Time.asctime(Time.localtime(secs));
    }

    private static synchronized String _shortday(int dow) {
        if (shortdays == null) {
            shortdays = new String[7];
            String[] names = datesyms.getShortWeekdays();
            for (int i = 0; i < 6; ++i) {
                Time.shortdays[i] = names[i + 2];
            }
            Time.shortdays[6] = names[1];
        }
        try {
            return shortdays[dow];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new PyException(Py.ValueError, new PyString("day of week out of range (0-6)"));
        }
    }

    private static synchronized String _shortmonth(int month0to11) {
        if (shortmonths == null) {
            shortmonths = new String[12];
            String[] names = datesyms.getShortMonths();
            for (int i = 0; i < 12; ++i) {
                Time.shortmonths[i] = names[i];
            }
        }
        try {
            return shortmonths[month0to11];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new PyException(Py.ValueError, new PyString("month out of range (1-12)"));
        }
    }

    private static String _padint(int i, int target) {
        String s = Integer.toString(i);
        int sz = s.length();
        if (target <= sz) {
            return s;
        }
        if (target == sz + 1) {
            return "0" + s;
        }
        if (target == sz + 2) {
            return "00" + s;
        }
        char[] c = new char[target - sz];
        Arrays.fill(c, '0');
        return new String(c) + s;
    }

    private static String _twodigit(int i) {
        return Time._padint(i, 2);
    }

    private static String _truncyear(int year) {
        String yearstr = Time._padint(year, 4);
        return yearstr.substring(yearstr.length() - 2, yearstr.length());
    }

    public static PyString asctime() {
        return Time.asctime(Time.localtime());
    }

    public static PyString asctime(PyTuple tup) {
        StringBuilder buf = new StringBuilder(25);
        buf.append(enshortdays[Time.item(tup, 6)]).append(' ');
        buf.append(enshortmonths[Time.item(tup, 1)]).append(' ');
        int dayOfMonth = Time.item(tup, 2);
        if (dayOfMonth < 10) {
            buf.append(' ');
        }
        buf.append(dayOfMonth).append(' ');
        buf.append(Time._twodigit(Time.item(tup, 3))).append(':');
        buf.append(Time._twodigit(Time.item(tup, 4))).append(':');
        buf.append(Time._twodigit(Time.item(tup, 5))).append(' ');
        return new PyString(buf.append(Time.item(tup, 0)).toString());
    }

    public static String locale_asctime(PyTuple tup) {
        Time.checkLocale();
        int day = Time.item(tup, 6);
        int mon = Time.item(tup, 1);
        return Time._shortday(day) + " " + Time._shortmonth(mon) + " " + Time._twodigit(Time.item(tup, 2)) + " " + Time._twodigit(Time.item(tup, 3)) + ":" + Time._twodigit(Time.item(tup, 4)) + ":" + Time._twodigit(Time.item(tup, 5)) + " " + Time.item(tup, 0);
    }

    public static void sleep(double secs) {
        try {
            Thread.sleep((long)(secs * 1000.0));
        }
        catch (InterruptedException e) {
            throw new PyException(Py.KeyboardInterrupt, "interrupted sleep");
        }
    }

    public static PyString strftime(String format) {
        return Time.strftime(format, Time.localtime());
    }

    /*
     * WARNING - void declaration
     */
    public static PyString strftime(String format, PyTuple tup) {
        Time.checkLocale();
        int[] items = new int[9];
        for (int i = 0; i < 9; ++i) {
            items[i] = Time.item(tup, i);
        }
        String s = "";
        int lastc = 0;
        Object var5_6 = null;
        while (lastc < format.length()) {
            void syms;
            int n = format.indexOf("%", lastc);
            if (n < 0) {
                s = s + format.substring(lastc);
                break;
            }
            if (n == format.length() - 1) {
                s = s + "%";
                break;
            }
            s = s + format.substring(lastc, n);
            switch (format.charAt(++n)) {
                case 'a': {
                    int cal = items[6];
                    s = s + Time._shortday(cal);
                    break;
                }
                case 'A': {
                    String[] i = datesyms.getWeekdays();
                    int cal = items[6];
                    if (0 <= cal && cal < 6) {
                        s = s + i[cal + 2];
                        break;
                    }
                    if (cal == 6) {
                        s = s + i[1];
                        break;
                    }
                    Time.throwValueError("day of week out of range (0 - 6)");
                    break;
                }
                case 'b': {
                    int cal = items[1];
                    s = s + Time._shortmonth(cal);
                    break;
                }
                case 'B': {
                    String[] i = datesyms.getMonths();
                    int cal = items[1];
                    s = s + i[cal];
                    break;
                }
                case 'c': {
                    s = s + Time.locale_asctime(tup);
                    break;
                }
                case 'd': {
                    s = s + Time._twodigit(items[2]);
                    break;
                }
                case 'H': {
                    s = s + Time._twodigit(items[3]);
                    break;
                }
                case 'I': {
                    int cal = items[3] % 12;
                    if (cal == 0) {
                        cal = 12;
                    }
                    s = s + Time._twodigit(cal);
                    break;
                }
                case 'j': {
                    s = s + Time._padint(items[7], 3);
                    break;
                }
                case 'm': {
                    s = s + Time._twodigit(items[1] + 1);
                    break;
                }
                case 'M': {
                    s = s + Time._twodigit(items[4]);
                    break;
                }
                case 'p': {
                    int cal = items[3];
                    String[] i = datesyms.getAmPmStrings();
                    if (0 <= cal && cal < 12) {
                        s = s + i[0];
                        break;
                    }
                    if (12 <= cal && cal < 24) {
                        s = s + i[1];
                        break;
                    }
                    Time.throwValueError("hour out of range (0-23)");
                    break;
                }
                case 'S': {
                    s = s + Time._twodigit(items[5]);
                    break;
                }
                case 'U': {
                    GregorianCalendar j;
                    if (j == null) {
                        j = Time._tupletocal(tup);
                    }
                    j.setFirstDayOfWeek(1);
                    j.setMinimalDaysInFirstWeek(7);
                    int cal = j.get(3);
                    if (j.get(2) == 0 && cal >= 52) {
                        cal = 0;
                    }
                    s = s + Time._twodigit(cal);
                    break;
                }
                case 'w': {
                    int cal = (items[6] + 1) % 7;
                    s = s + cal;
                    break;
                }
                case 'W': {
                    GregorianCalendar j;
                    if (j == null) {
                        j = Time._tupletocal(tup);
                    }
                    j.setFirstDayOfWeek(2);
                    j.setMinimalDaysInFirstWeek(7);
                    int cal = j.get(3);
                    if (j.get(2) == 0 && cal >= 52) {
                        cal = 0;
                    }
                    s = s + Time._twodigit(cal);
                    break;
                }
                case 'x': {
                    s = s + Time._twodigit(items[1] + 1) + "/" + Time._twodigit(items[2]) + "/" + Time._truncyear(items[0]);
                    break;
                }
                case 'X': {
                    s = s + Time._twodigit(items[3]) + ":" + Time._twodigit(items[4]) + ":" + Time._twodigit(items[5]);
                    break;
                }
                case 'Y': {
                    s = s + Time._padint(items[0], 4);
                    break;
                }
                case 'y': {
                    s = s + Time._truncyear(items[0]);
                    break;
                }
                case 'Z': {
                    GregorianCalendar j;
                    if (j == null) {
                        j = Time._tupletocal(tup);
                    }
                    s = s + j.getTimeZone().getDisplayName(items[8] > 0, 0);
                    break;
                }
                case '%': {
                    s = s + "%";
                    break;
                }
                default: {
                    s = s + "%" + format.charAt((int)syms);
                    ++syms;
                }
            }
            lastc = syms + true;
            ++syms;
        }
        return new PyString(s);
    }

    private static void checkLocale() {
        if (!Locale.getDefault().equals(currentLocale)) {
            currentLocale = Locale.getDefault();
            datesyms = new DateFormatSymbols(currentLocale);
            shortdays = null;
            shortmonths = null;
        }
    }

    public static PyTuple strptime(String data_string) {
        return Time.strptime(data_string, DEFAULT_FORMAT_PY);
    }

    private static PyTuple pystrptime(String data_string, String format) {
        return (PyTuple)__builtin__.__import__("_strptime").__getattr__("strptime").__call__(Py.newUnicode(data_string), (PyObject)Py.newUnicode(format));
    }

    public static PyTuple strptime(String data_string, String format) {
        if (format == null || data_string == null) {
            throw Py.TypeError("expected string of buffer");
        }
        String jformat = Time.py2java_format(format);
        if (jformat == null) {
            return Time.pystrptime(data_string, format);
        }
        SimpleDateFormat d = new SimpleDateFormat(jformat);
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(d.parse(data_string));
        }
        catch (ParseException e) {
            Time.throwValueError("time data did not match format:  data=" + data_string + "  fmt=" + format);
        }
        int isdst = -1;
        if (jformat.contains("zzz")) {
            isdst = cal.getTimeZone().inDaylightTime(cal.getTime()) ? 1 : 0;
        }
        return new PyTuple(new PyInteger(cal.get(1)), new PyInteger(cal.get(2) + 1), new PyInteger(cal.get(5)), new PyInteger(cal.get(10) + 12 * cal.get(9)), new PyInteger(cal.get(12)), new PyInteger(cal.get(13)), new PyInteger((cal.get(7) - 2) % 7), new PyInteger(cal.get(6)), new PyInteger(isdst));
    }

    private static String py2java_format(String format) {
        StringBuilder builder = new StringBuilder();
        boolean directive = false;
        boolean inQuote = false;
        for (int i = 0; i < format.length(); ++i) {
            String translated;
            char charAt = format.charAt(i);
            if (charAt == '%' && !directive) {
                directive = true;
                continue;
            }
            if (!directive) {
                boolean needsQuote;
                boolean bl = needsQuote = charAt >= 'A' && charAt <= 'Z' || charAt >= 'a' && charAt <= 'z';
                if (needsQuote && !inQuote || !needsQuote && inQuote) {
                    builder.append("'");
                    inQuote = needsQuote;
                }
                builder.append(charAt);
                continue;
            }
            if (inQuote) {
                builder.append("'");
                inQuote = false;
            }
            if ((translated = py2java.get(Character.valueOf(charAt))) == null && notSupported.contains(Character.valueOf(charAt))) {
                return null;
            }
            builder.append(translated != null ? translated : Character.valueOf(charAt));
            directive = false;
        }
        return builder.toString();
    }

    static {
        currentLocale = null;
        datesyms = new DateFormatSymbols();
        shortdays = null;
        shortmonths = null;
        enshortdays = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        enshortmonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        altzone = -1;
        tzname = null;
        py2java = new HashMap<Character, String>(){
            {
                this.put(Character.valueOf('a'), "EEE");
                this.put(Character.valueOf('A'), "EEEE");
                this.put(Character.valueOf('b'), "MMM");
                this.put(Character.valueOf('B'), "MMMM");
                this.put(Character.valueOf('c'), "EEE MMM dd HH:mm:ss yyyy");
                this.put(Character.valueOf('d'), "dd");
                this.put(Character.valueOf('H'), "HH");
                this.put(Character.valueOf('I'), "hh");
                this.put(Character.valueOf('j'), "DDD");
                this.put(Character.valueOf('m'), "MM");
                this.put(Character.valueOf('M'), "mm");
                this.put(Character.valueOf('p'), "a");
                this.put(Character.valueOf('S'), "ss");
                this.put(Character.valueOf('U'), "ww");
                this.put(Character.valueOf('W'), "ww");
                this.put(Character.valueOf('x'), "MM/dd/yy");
                this.put(Character.valueOf('X'), "HH:mm:ss");
                this.put(Character.valueOf('y'), "yy");
                this.put(Character.valueOf('Y'), "yyyy");
                this.put(Character.valueOf('Z'), "zzz");
                this.put(Character.valueOf('%'), "%");
            }
        };
        notSupported = new ArrayList<Character>(){
            {
                this.add(Character.valueOf('w'));
            }
        };
    }
}

