## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include = FALSE---------------------------------------------------

devtools::load_all(".")
library(tidyverse)


## -----------------------------------------------------------------------------
i10_wide

## -----------------------------------------------------------------------------
data <- clean_data(dat = i10_wide,
                   id = patient_id,
                   style = "wide",
                   prefix_dx = "dx")

## ---- echo = FALSE------------------------------------------------------------
head(data, 10)

## -----------------------------------------------------------------------------
cms <- socialrisk(dat = data, id = patient_id, dx = dx, taxonomy = "cms")

## ---- echo = FALSE------------------------------------------------------------
head(cms, 5)

## -----------------------------------------------------------------------------
mha <- socialrisk(dat = data, id = patient_id, dx = dx, taxonomy = "mha")

## ---- echo = FALSE------------------------------------------------------------
head(mha, 5)

## -----------------------------------------------------------------------------
siren <- socialrisk(dat = data, id = patient_id, dx = dx, taxonomy = "siren")

## ---- echo = FALSE------------------------------------------------------------
head(siren, 5)

