/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.util.Random;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.OutputZipper;

public class CrossValidationSplitResultProducer
extends CrossValidationResultProducer {
    static final long serialVersionUID = 1403798164046795073L;

    @Override
    public String globalInfo() {
        return "Carries out one split of a repeated k-fold cross-validation, using the set SplitEvaluator to generate some results. Note that the run number is actually the nth split of a repeated k-fold cross-validation, i.e. if k=10, run number 100 is the 10th fold of the 10th cross-validation run. This producer's sole purpose is to allow more fine-grained distribution of cross-validation experiments. If the class attribute is nominal, the dataset is stratified.";
    }

    @Override
    public void doRunKeys(int run) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        Object[] seKey = this.m_SplitEvaluator.getKey();
        Object[] key = new Object[seKey.length + 3];
        key[0] = Utils.backQuoteChars(this.m_Instances.relationName());
        key[2] = "" + ((run - 1) % this.m_NumFolds + 1);
        key[1] = "" + ((run - 1) / this.m_NumFolds + 1);
        System.arraycopy(seKey, 0, key, 3, seKey.length);
        if (this.m_ResultListener.isResultRequired(this, key)) {
            this.m_ResultListener.acceptResult(this, key, null);
        }
    }

    @Override
    public void doRun(int run) throws Exception {
        if (this.getRawOutput() && this.m_ZipDest == null) {
            this.m_ZipDest = new OutputZipper(this.m_OutputFile);
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        int fold = (run - 1) % this.m_NumFolds;
        run = (run - 1) / this.m_NumFolds + 1;
        Instances runInstances = new Instances(this.m_Instances);
        Random random = new Random(run);
        runInstances.randomize(random);
        if (runInstances.classAttribute().isNominal()) {
            runInstances.stratify(this.m_NumFolds);
        }
        Object[] seKey = this.m_SplitEvaluator.getKey();
        Object[] key = new Object[seKey.length + 3];
        key[0] = Utils.backQuoteChars(this.m_Instances.relationName());
        key[1] = "" + run;
        key[2] = "" + (fold + 1);
        System.arraycopy(seKey, 0, key, 3, seKey.length);
        if (this.m_ResultListener.isResultRequired(this, key)) {
            for (int tempFold = 0; tempFold < fold; ++tempFold) {
                Instances train = runInstances.trainCV(this.m_NumFolds, tempFold, random);
            }
            Instances train = runInstances.trainCV(this.m_NumFolds, fold, random);
            Instances test = runInstances.testCV(this.m_NumFolds, fold);
            Object[] seResults = this.m_SplitEvaluator.getResult(train, test);
            Object[] results = new Object[seResults.length + 1];
            results[0] = CrossValidationSplitResultProducer.getTimestamp();
            System.arraycopy(seResults, 0, results, 1, seResults.length);
            if (this.m_debugOutput) {
                String resultName = ("" + run + "." + (fold + 1) + "." + Utils.backQuoteChars(runInstances.relationName()) + "." + this.m_SplitEvaluator.toString()).replace(' ', '_');
                resultName = Utils.removeSubstring(resultName, "weka.classifiers.");
                resultName = Utils.removeSubstring(resultName, "weka.filters.");
                resultName = Utils.removeSubstring(resultName, "weka.attributeSelection.");
                this.m_ZipDest.zipit(this.m_SplitEvaluator.getRawResultOutput(), resultName);
            }
            this.m_ResultListener.acceptResult(this, key, results);
        }
    }

    @Override
    public String toString() {
        String result = "CrossValidationSplitResultProducer: ";
        result = result + this.getCompatibilityState();
        result = this.m_Instances == null ? result + ": <null Instances>" : result + ": " + Utils.backQuoteChars(this.m_Instances.relationName());
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6922 $");
    }
}

