## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(DYNATE)

## -----------------------------------------------------------------------------
str(snp_dat)

## -----------------------------------------------------------------------------
M <- 5 # leaf size
L <- 3 # layer number
alpha <- 0.05 # desired FDR

## -----------------------------------------------------------------------------
# Model consider covariates effect:
t1 <- Sys.time()
p_leaf <- Test_Leaf(snp_dat=snp_dat,thresh_val=M)
t2 <- Sys.time()
t2-t1


## -----------------------------------------------------------------------------
str(p_leaf)

## -----------------------------------------------------------------------------
out <- DYNATE(struct_map=p_leaf,L=L,alpha=alpha)

## -----------------------------------------------------------------------------
str(out)

