/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.dataengine.impl.DSISimpleArray;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.exceptions.ErrorException;

public class PGArray
extends DSISimpleArray {
    public PGArray(Object object, IColumn iColumn, IColumn iColumn2) {
        super(object, iColumn, iColumn2);
    }

    @Override
    public Object createArray(long l, int n) throws ErrorException {
        if (l < 0L) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SUBARRAY_INVALID_INDEX_ERR.name());
            throw errorException;
        }
        if (l > 0L && n < 0) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SUBARRAY_INVALID_COUNT_ERR.name());
            throw errorException;
        }
        if ((long)n > (long)this.m_length - l || l >= (long)this.m_length) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SUBARRAY_INVALID_ELEMENT_COUNT_ERR.name());
            throw errorException;
        }
        return super.createArray(l, n);
    }

    @Override
    public String getStringRepresentation() {
        Object[] objectArray = (Object[])this.m_array;
        if (objectArray == null) {
            return "null";
        }
        int n = objectArray.length - 1;
        if (n == -1) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        int n2 = 0;
        while (true) {
            stringBuilder.append(String.valueOf(objectArray[n2]));
            if (n2 == n) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(",");
            ++n2;
        }
    }
}

