/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.tiger.filechooser;

import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class OSXTigerFileSystemView
extends QuaquaFileSystemView {
    private static final File volumesFolder = new File("/Volumes");
    private static final File networkFolder = new File("/Network");
    private static final File computer = new File("/");
    private static File systemVolume;
    private static final HashSet hiddenTopLevelNames;
    private static final HashSet hiddenDirectoryNames;

    public File getSystemVolume() {
        if (systemVolume == null) {
            File[] volumes = volumesFolder.listFiles();
            File sys = null;
            for (int i = 0; i < volumes.length; ++i) {
                try {
                    if (!volumes[i].getCanonicalFile().equals(computer)) continue;
                    sys = volumes[i];
                    break;
                }
                catch (IOException e) {
                    continue;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            systemVolume = sys == null ? computer : sys;
        }
        return systemVolume;
    }

    public File getComputer() {
        return computer;
    }

    public File getParentDirectory(File dir) {
        File parent;
        File file = parent = this.isRoot(dir) ? null : super.getParentDirectory(dir);
        if (parent != null && parent.equals(computer)) {
            parent = this.getSystemVolume();
        }
        return parent;
    }

    public File[] getRoots() {
        ArrayList<File> roots = new ArrayList<File>();
        File[] fileArray = volumesFolder.listFiles();
        if (fileArray != null) {
            roots.addAll(Arrays.asList(fileArray));
        }
        roots.add(networkFolder);
        return roots.toArray(new File[roots.size()]);
    }

    public boolean isHiddenFile(File f) {
        if (f.isHidden()) {
            return true;
        }
        String name = f.getName();
        if (name.length() == 0) {
            return false;
        }
        if (name.charAt(name.length() - 1) == '\r') {
            return true;
        }
        if (hiddenTopLevelNames.contains(name) && (f.getParent() == null || this.isRoot(f.getParentFile()))) {
            return true;
        }
        return hiddenDirectoryNames.contains(name);
    }

    public boolean isRoot(File aFile) {
        return aFile.equals(computer) || aFile.equals(networkFolder) || aFile.getParentFile() != null && aFile.getParentFile().equals(volumesFolder);
    }

    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    public File getChild(File parent, String fileName) {
        return new File(parent, fileName);
    }

    public boolean isFileSystemRoot(File dir) {
        File parentFile = dir.getParentFile();
        return parentFile == null || parentFile.equals(volumesFolder);
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    static {
        hiddenTopLevelNames = new HashSet();
        hiddenDirectoryNames = new HashSet();
        String[] names = new String[]{"AppleShare PDS", "automount", "bin", "Cleanup At Startup", "cores", "Desktop DB", "Desktop DF", "dev", "etc", "home", "mach", "mach_kernel", "mach_kernel.ctfsys", "mach.sym", "net", "opt", "private", "sbin", "Temporary Items", "TheVolumeSettingsFolder", "TheFindByContentFolder", "tmp", "Trash", "usr", "var", "Volumes", "\u0003\u0002\u0001Move&Rename"};
        hiddenTopLevelNames.addAll(Arrays.asList(names));
        names = new String[]{"$RECYCLE.BIN", "Thumbs.db", "desktop.ini"};
        hiddenDirectoryNames.addAll(Arrays.asList(names));
    }
}

