/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarSet;

class LoaderDelphiFilter {
    static final int VT_unknown = 0;
    static final int VT_known = 1;
    static final int VT_num = 2;
    static final int VT_cat = 4;
    static final int VT_miss = 8;
    SVarSet vs;
    int[] vt;
    int rows = -1;

    LoaderDelphiFilter(SVarSet vs) {
        this.vs = vs;
        this.vt = new int[vs.count()];
    }

    void nextRecord() {
        ++this.rows;
    }

    void addValue(int col, String val, int line) {
        if (this.rows < 0) {
            this.rows = 0;
        }
        if (val != null && val.equals("NA")) {
            val = null;
        }
        if (col < 0 || col >= this.vt.length) {
            System.out.println("Loader, line " + line + ": column " + (col + 1) + " has no header, dropping.");
            return;
        }
        SVar v = this.vs.at(col);
        if (v == null) {
            System.out.println("Loader, line " + line + ": variable for column " + (col + 1) + " is null.");
            return;
        }
        int vsz = v.size();
        if (vsz < this.rows) {
            System.out.println("Loader, line " + line + ": previous rows are missing (" + (this.rows - vsz) + "), filling with missings.");
            while (vsz < this.rows) {
                v.add(null);
                ++vsz;
            }
        }
        if (this.rows < vsz) {
            System.out.println("Loader, line " + line + ": FATAL! The variable " + v.getName() + " has already " + vsz + " entries, but this is the entry " + this.rows + "!");
            return;
        }
        if (this.vt[col] == 0) {
            if (val == null) {
                v.add(null);
                return;
            }
            try {
                Double d = Double.valueOf(val);
                int n = col;
                this.vt[n] = this.vt[n] | 3;
                v.add(d);
                return;
            }
            catch (NumberFormatException nfe) {
                v.add(val);
                v.categorize();
                int n = col;
                this.vt[n] = this.vt[n] | 5;
            }
        } else {
            if ((this.vt[col] & 2) > 0) {
                try {
                    Double d = Double.valueOf(val);
                    v.add(d);
                    return;
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Loader, line " + line + ", column " + (col + 1) + ": expected numerical value, found \"" + val + "\"; treating as missing.");
                    v.add(null);
                    return;
                }
            }
            v.add(val);
        }
    }
}

