/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import java.awt.event.ActionEvent;
import java.util.List;
import uk.ac.rhul.cs.cl1.ui.cytoscape.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CytoscapePlugin;
import uk.ac.rhul.cs.cl1.ui.cytoscape.Graph;

public class AffinityColouringAction
extends CytoscapeAction {
    private static AffinityColouringAction globalInstance;

    public AffinityColouringAction() {
        super("Color nodes by affinity");
        this.putValue("LongDescription", "Color the nodes of the selected network by their affinity to the currently selected set of nodes as a cluster");
        this.putValue("MnemonicKey", 65);
        this.setPreferredMenu("Plugins.ClusterONE");
    }

    public void actionPerformed(ActionEvent event) {
        String weightAttr;
        ControlPanel panel = ControlPanel.getShownInstance();
        if (panel == null) {
            return;
        }
        CyNetwork network = Cytoscape.getCurrentNetwork();
        Graph graph = CytoscapePlugin.convertCyNetworkToGraph(network, weightAttr = panel.getWeightAttributeName());
        if (graph == null) {
            return;
        }
        List<Integer> indices = graph.getMappedNodeIndices(network.getSelectedNodes());
        CytoscapePlugin.setAffinityAttributesOnGraph(graph, indices);
    }

    public static synchronized AffinityColouringAction getGlobalInstance() {
        if (globalInstance == null) {
            globalInstance = new AffinityColouringAction();
        }
        return globalInstance;
    }

    public boolean isInToolBar() {
        return false;
    }
}

