/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataTableInfo;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.List;

public class TsDataTable {
    private final List<TsData> m_data = new ArrayList<TsData>();
    private TsPeriodSelector m_periodselector = new TsPeriodSelector();
    private TsDomain m_domain;
    private int[] m_freqs;
    private int[] m_ids;
    private int[] m_ns;
    private int m_curfreq;
    private int m_firstid;
    private int m_count;

    private static int getid(int curid, int freq, int newfreq) {
        if (newfreq == 0) {
            return Integer.MIN_VALUE;
        }
        if (freq == newfreq) {
            return curid;
        }
        int c = freq / newfreq;
        if ((curid -= c - 1) % c != 0) {
            return Integer.MIN_VALUE;
        }
        return curid / c;
    }

    public void clear() {
        this.m_data.clear();
        this.internalClear();
    }

    public double getData(int periodId, int seriesId) {
        this.recalc();
        if (periodId < 0 || periodId >= this.m_count || seriesId < 0 || seriesId >= this.m_data.size()) {
            throw new TsException("periodId", "TSTable");
        }
        int id = TsDataTable.getid(periodId + this.m_firstid, this.m_curfreq, this.m_freqs[seriesId]);
        if (id == Integer.MIN_VALUE) {
            throw new TsException("periodId", "TSTable");
        }
        if (id < this.m_ids[seriesId] || id >= this.m_ids[seriesId] + this.m_ns[seriesId]) {
            throw new TsException("seriesId", "TSTable");
        }
        return this.m_data.get(seriesId).get(id - this.m_ids[seriesId]);
    }

    public TsDataTableInfo getDataInfo(int periodId, int seriesId) {
        this.recalc();
        if (periodId < 0 || periodId >= this.m_count || seriesId < 0 || seriesId >= this.m_data.size()) {
            throw new TsException("Invalid id", "TSTable");
        }
        int id = TsDataTable.getid(periodId + this.m_firstid, this.m_curfreq, this.m_freqs[seriesId]);
        if (id == Integer.MIN_VALUE) {
            return TsDataTableInfo.Empty;
        }
        if (id < this.m_ids[seriesId] || id >= this.m_ids[seriesId] + this.m_ns[seriesId]) {
            return TsDataTableInfo.Empty;
        }
        double data = this.m_data.get(seriesId).get(id - this.m_ids[seriesId]);
        if (!Double.isFinite(data)) {
            return TsDataTableInfo.Missing;
        }
        return TsDataTableInfo.Valid;
    }

    public TsDomain getDomain() {
        this.recalc();
        return this.m_domain;
    }

    public TsPeriodSelector getSelector() {
        return this.m_periodselector.clone();
    }

    public int getSeriesCount() {
        return this.m_data.size();
    }

    public void insert(int pos, TsData ts) {
        this.internalClear();
        if (pos < 0 || pos >= this.m_data.size()) {
            this.m_data.add(ts);
        } else {
            this.m_data.add(pos, ts);
        }
    }

    public void add(TsData ts) {
        this.internalClear();
        this.m_data.add(ts);
    }

    public void add(Iterable<TsData> ts) {
        this.internalClear();
        for (TsData s : ts) {
            this.m_data.add(s);
        }
    }

    public void add(TsData ... ts) {
        this.internalClear();
        for (TsData s : ts) {
            this.m_data.add(s);
        }
    }

    private void internalClear() {
        this.m_curfreq = 0;
        this.m_count = 0;
        this.m_domain = null;
        this.m_freqs = null;
        this.m_ids = null;
        this.m_ns = null;
    }

    public boolean isEmpty() {
        this.recalc();
        return this.m_count == 0;
    }

    private void recalc() {
        int i;
        if (this.m_curfreq != 0) {
            return;
        }
        int n = this.m_data.size();
        if (n == 0) {
            return;
        }
        this.m_freqs = new int[n];
        this.m_ids = new int[n];
        this.m_ns = new int[n];
        int ifirst = -1;
        for (i = 0; i < n; ++i) {
            if (this.m_data.get(i) == null) continue;
            if (ifirst < 0) {
                ifirst = i;
            }
            TsDomain tmp = this.m_data.get(i).getDomain();
            this.m_freqs[i] = tmp.getFrequency().intValue();
            this.m_ids[i] = tmp.firstid();
            this.m_ns[i] = tmp.getLength();
        }
        if (ifirst < 0) {
            return;
        }
        this.m_curfreq = this.m_freqs[ifirst];
        for (i = ifirst + 1; i < n; ++i) {
            if (this.m_freqs[i] == 0 || this.m_curfreq % this.m_freqs[i] == 0) continue;
            this.m_curfreq *= this.m_freqs[i];
            if (this.m_curfreq <= 12) continue;
            this.m_curfreq = 12;
        }
        int c = this.m_curfreq / this.m_freqs[ifirst];
        int firstid = (this.m_ids[ifirst] + 1) * c - 1;
        int lastid = firstid + (this.m_ns[ifirst] - 1) * c;
        for (int i2 = ifirst + 1; i2 < n; ++i2) {
            if (this.m_freqs[i2] == 0) continue;
            c = this.m_curfreq / this.m_freqs[i2];
            int f = (this.m_ids[i2] + 1) * c - 1;
            int l = f + (this.m_ns[i2] - 1) * c;
            if (f < firstid) {
                firstid = f;
            }
            if (l <= lastid) continue;
            lastid = l;
        }
        TsPeriod start = new TsPeriod(TsFrequency.valueOf(this.m_curfreq), firstid);
        TsDomain dtmp = new TsDomain(start, lastid - firstid + 1);
        this.m_domain = dtmp.select(this.m_periodselector);
        this.m_firstid = dtmp.firstid();
        this.m_count = dtmp.getLength();
    }

    public TsData series(int idx) {
        return this.m_data.get(idx);
    }

    public void setSelector(TsPeriodSelector periodSelector) {
        this.m_periodselector = periodSelector.clone();
        this.internalClear();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] headers) {
        if (headers != null && headers.length != this.m_data.size()) {
            throw new IllegalArgumentException("Incompatible headers for this TsDataTable");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.m_data.size(); ++i) {
            builder.append('\t');
            if (headers == null) {
                builder.append("s").append(i + 1);
                continue;
            }
            builder.append(headers[i]);
        }
        TsDomain dom = this.getDomain();
        if (dom == null || dom.isEmpty()) {
            return builder.toString();
        }
        for (int j = 0; j < dom.getLength(); ++j) {
            builder.append(System.lineSeparator()).append(dom.get(j));
            for (int i = 0; i < this.m_data.size(); ++i) {
                TsDataTableInfo dataInfo = this.getDataInfo(j, i);
                if (dataInfo == TsDataTableInfo.Valid) {
                    builder.append('\t').append(this.getData(j, i));
                    continue;
                }
                if (dataInfo == TsDataTableInfo.Missing) {
                    builder.append("\t.");
                    continue;
                }
                builder.append('\t');
            }
        }
        return builder.toString();
    }
}

