/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.mi.TLDSimple_Optm;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class TLDSimple
extends RandomizableClassifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 9040995947243286591L;
    protected double[][] m_MeanP = null;
    protected double[][] m_MeanN = null;
    protected double[][] m_SumP = null;
    protected double[][] m_SumN = null;
    protected double[] m_SgmSqP;
    protected double[] m_SgmSqN;
    protected double[] m_ParamsP = null;
    protected double[] m_ParamsN = null;
    protected int m_Dimension = 0;
    protected double[] m_Class = null;
    protected int m_NumClasses = 2;
    public static double ZERO = 1.0E-12;
    protected int m_Run = 1;
    protected double m_Cutoff;
    protected boolean m_UseEmpiricalCutOff = false;
    private double[] m_LkRatio;
    private Instances m_Attribute = null;

    public String globalInfo() {
        return "A simpler version of TLD, mu random but sigma^2 fixed and estimated via data.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Xin Xu");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Statistical learning in multiple instance problem");
        technicalInformation.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, NZ");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "0657.594");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.BINARY_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return capabilities;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        int n6 = instances.numInstances();
        this.m_Dimension = instances.attribute(1).relation().numAttributes();
        this.m_Attribute = instances.attribute(1).relation().stringFreeStructure();
        Instances instances2 = new Instances(instances, 0);
        Instances instances3 = new Instances(instances, 0);
        for (n5 = 0; n5 < n6; ++n5) {
            Instance instance = instances.instance(n5);
            if (instance.classValue() == 1.0) {
                instances2.add(instance);
                continue;
            }
            instances3.add(instance);
        }
        n5 = instances2.numInstances();
        int n7 = instances3.numInstances();
        this.m_MeanP = new double[n5][this.m_Dimension];
        this.m_SumP = new double[n5][this.m_Dimension];
        this.m_MeanN = new double[n7][this.m_Dimension];
        this.m_SumN = new double[n7][this.m_Dimension];
        this.m_ParamsP = new double[2 * this.m_Dimension];
        this.m_ParamsN = new double[2 * this.m_Dimension];
        this.m_SgmSqP = new double[this.m_Dimension];
        this.m_SgmSqN = new double[this.m_Dimension];
        double[][] dArray = new double[n5][this.m_Dimension];
        double[][] dArray2 = new double[n7][this.m_Dimension];
        double[] dArray3 = new double[this.m_Dimension];
        double[] dArray4 = new double[this.m_Dimension];
        double[] dArray5 = new double[this.m_Dimension];
        double[] dArray6 = new double[this.m_Dimension];
        double[] dArray7 = new double[this.m_Dimension];
        double[] dArray8 = new double[this.m_Dimension];
        double[] dArray9 = new double[this.m_Dimension];
        double[] dArray10 = new double[this.m_Dimension];
        double[] dArray11 = new double[this.m_Dimension];
        double[] dArray12 = new double[this.m_Dimension];
        for (n4 = 0; n4 < n5; ++n4) {
            object = instances2.instance(n4).relationalValue(1);
            for (n3 = 0; n3 < ((Instances)object).numAttributes(); ++n3) {
                this.m_MeanP[n4][n3] = ((Instances)object).meanOrMode(n3);
                dArray[n4][n3] = ((Instances)object).variance(n3);
            }
            n3 = 0;
            n2 = 0;
            while (n3 < this.m_Dimension) {
                if (dArray[n4][n3] <= 0.0) {
                    dArray[n4][n3] = 0.0;
                }
                if (!Double.isNaN(this.m_MeanP[n4][n3])) {
                    for (n = 0; n < ((Instances)object).numInstances(); ++n) {
                        if (((Instances)object).instance(n).isMissing(n2)) continue;
                        double[] dArray13 = this.m_SumP[n4];
                        int n8 = n3;
                        dArray13[n8] = dArray13[n8] + ((Instances)object).instance(n).weight();
                    }
                    int n9 = n3;
                    dArray5[n9] = dArray5[n9] + this.m_MeanP[n4][n3];
                    int n10 = n3;
                    dArray7[n10] = dArray7[n10] + this.m_MeanP[n4][n3] * this.m_MeanP[n4][n3];
                    if (this.m_SumP[n4][n3] > 1.0 && dArray[n4][n3] > ZERO) {
                        int n11 = n3;
                        this.m_SgmSqP[n11] = this.m_SgmSqP[n11] + dArray[n4][n3] * (this.m_SumP[n4][n3] - 1.0) / this.m_SumP[n4][n3];
                        int n12 = n3;
                        dArray3[n12] = dArray3[n12] + 1.0;
                        int n13 = n3;
                        dArray11[n13] = dArray11[n13] + 1.0 / this.m_SumP[n4][n3];
                    } else {
                        int n14 = n3;
                        dArray9[n14] = dArray9[n14] + 1.0;
                    }
                }
                ++n3;
                ++n2;
            }
        }
        for (n4 = 0; n4 < n7; ++n4) {
            object = instances3.instance(n4).relationalValue(1);
            for (n3 = 0; n3 < ((Instances)object).numAttributes(); ++n3) {
                this.m_MeanN[n4][n3] = ((Instances)object).meanOrMode(n3);
                dArray2[n4][n3] = ((Instances)object).variance(n3);
            }
            n3 = 0;
            n2 = 0;
            while (n3 < this.m_Dimension) {
                if (dArray2[n4][n3] <= 0.0) {
                    dArray2[n4][n3] = 0.0;
                }
                if (!Double.isNaN(this.m_MeanN[n4][n3])) {
                    for (n = 0; n < ((Instances)object).numInstances(); ++n) {
                        if (((Instances)object).instance(n).isMissing(n2)) continue;
                        double[] dArray14 = this.m_SumN[n4];
                        int n15 = n3;
                        dArray14[n15] = dArray14[n15] + ((Instances)object).instance(n).weight();
                    }
                    int n16 = n3;
                    dArray6[n16] = dArray6[n16] + this.m_MeanN[n4][n3];
                    int n17 = n3;
                    dArray8[n17] = dArray8[n17] + this.m_MeanN[n4][n3] * this.m_MeanN[n4][n3];
                    if (this.m_SumN[n4][n3] > 1.0 && dArray2[n4][n3] > ZERO) {
                        int n18 = n3;
                        this.m_SgmSqN[n18] = this.m_SgmSqN[n18] + dArray2[n4][n3] * (this.m_SumN[n4][n3] - 1.0) / this.m_SumN[n4][n3];
                        int n19 = n3;
                        dArray4[n19] = dArray4[n19] + 1.0;
                        int n20 = n3;
                        dArray12[n20] = dArray12[n20] + 1.0 / this.m_SumN[n4][n3];
                    } else {
                        int n21 = n3;
                        dArray10[n21] = dArray10[n21] + 1.0;
                    }
                }
                ++n3;
                ++n2;
            }
        }
        for (n4 = 0; n4 < this.m_Dimension; ++n4) {
            if (this.m_SgmSqP[n4] != 0.0) {
                int n22 = n4;
                this.m_SgmSqP[n22] = this.m_SgmSqP[n22] / (dArray3[n4] - dArray11[n4]);
            } else {
                this.m_SgmSqP[n4] = 0.0;
            }
            if (this.m_SgmSqN[n4] != 0.0) {
                int n23 = n4;
                this.m_SgmSqN[n23] = this.m_SgmSqN[n23] / (dArray4[n4] - dArray12[n4]);
            } else {
                this.m_SgmSqN[n4] = 0.0;
            }
            int n24 = n4;
            dArray3[n24] = dArray3[n24] + dArray9[n4];
            int n25 = n4;
            dArray4[n25] = dArray4[n25] + dArray10[n4];
            int n26 = n4;
            dArray5[n26] = dArray5[n26] / dArray3[n4];
            int n27 = n4;
            dArray6[n27] = dArray6[n27] / dArray4[n4];
            dArray7[n4] = dArray7[n4] / (dArray3[n4] - 1.0) - dArray5[n4] * dArray5[n4] * dArray3[n4] / (dArray3[n4] - 1.0);
            dArray8[n4] = dArray8[n4] / (dArray4[n4] - 1.0) - dArray6[n4] * dArray6[n4] * dArray4[n4] / (dArray4[n4] - 1.0);
        }
        double[][] dArray15 = new double[2][2];
        object = new double[2];
        double[] dArray16 = new double[2];
        Random random = new Random(this.m_Seed);
        for (int i = 0; i < this.m_Dimension; ++i) {
            double d;
            double d2;
            int n28;
            double d3;
            int n29;
            object[0] = dArray7[i];
            if (object[0] <= ZERO) {
                object[0] = 1.0;
            }
            object[1] = dArray5[i];
            dArray16[0] = dArray8[i];
            if (dArray16[0] <= ZERO) {
                dArray16[0] = 1.0;
            }
            dArray16[1] = dArray6[i];
            dArray15[0][0] = ZERO;
            dArray15[0][1] = Double.NaN;
            dArray15[1][0] = Double.NaN;
            dArray15[1][1] = Double.NaN;
            double d4 = Double.MAX_VALUE;
            double d5 = Double.MAX_VALUE;
            TLDSimple_Optm tLDSimple_Optm = null;
            TLDSimple_Optm tLDSimple_Optm2 = null;
            boolean bl = true;
            double[] dArray17 = new double[n5];
            double[] dArray18 = new double[n5];
            double[] dArray19 = new double[n7];
            double[] dArray20 = new double[n7];
            for (n29 = 0; n29 < n5; ++n29) {
                dArray17[n29] = this.m_SumP[n29][i];
                dArray18[n29] = this.m_MeanP[n29][i];
            }
            for (n29 = 0; n29 < n7; ++n29) {
                dArray19[n29] = this.m_SumN[n29][i];
                dArray20[n29] = this.m_MeanN[n29][i];
            }
            for (n29 = 0; n29 < this.m_Run; ++n29) {
                tLDSimple_Optm = new TLDSimple_Optm();
                tLDSimple_Optm.setNum(dArray17);
                tLDSimple_Optm.setSgmSq(this.m_SgmSqP[i]);
                if (this.getDebug()) {
                    System.out.println("m_SgmSqP[" + i + "]= " + this.m_SgmSqP[i]);
                }
                tLDSimple_Optm.setXBar(dArray18);
                object = tLDSimple_Optm.findArgmin((double[])object, dArray15);
                while (object == null) {
                    object = tLDSimple_Optm.getVarbValues();
                    if (this.getDebug()) {
                        System.out.println("!!! 200 iterations finished, not enough!");
                    }
                    object = tLDSimple_Optm.findArgmin((double[])object, dArray15);
                }
                d3 = tLDSimple_Optm.getMinFunction();
                if (!Double.isNaN(d3) && d3 < d4) {
                    d4 = d3;
                    for (n28 = 0; n28 < 2; ++n28) {
                        this.m_ParamsP[2 * i + n28] = (double)object[n28];
                    }
                }
                if (Double.isNaN(d3)) {
                    object = new double[2];
                    bl = false;
                }
                if (!bl) {
                    --n29;
                    bl = true;
                }
                n28 = random.nextInt(n5);
                while (Double.isNaN(this.m_MeanP[n28][i])) {
                    n28 = random.nextInt(n5);
                }
                d2 = this.m_MeanP[n28][i];
                d = (d2 - object[1]) * (d2 - object[1]);
                object[0] = d;
                object[1] = d2;
            }
            for (n29 = 0; n29 < this.m_Run; ++n29) {
                tLDSimple_Optm2 = new TLDSimple_Optm();
                tLDSimple_Optm2.setNum(dArray19);
                tLDSimple_Optm2.setSgmSq(this.m_SgmSqN[i]);
                if (this.getDebug()) {
                    System.out.println(this.m_SgmSqN[i]);
                }
                tLDSimple_Optm2.setXBar(dArray20);
                dArray16 = tLDSimple_Optm2.findArgmin(dArray16, dArray15);
                while (dArray16 == null) {
                    dArray16 = tLDSimple_Optm2.getVarbValues();
                    if (this.getDebug()) {
                        System.out.println("!!! 200 iterations finished, not enough!");
                    }
                    dArray16 = tLDSimple_Optm2.findArgmin(dArray16, dArray15);
                }
                d3 = tLDSimple_Optm2.getMinFunction();
                if (!Double.isNaN(d3) && d3 < d5) {
                    d5 = d3;
                    for (n28 = 0; n28 < 2; ++n28) {
                        this.m_ParamsN[2 * i + n28] = dArray16[n28];
                    }
                }
                if (Double.isNaN(d3)) {
                    dArray16 = new double[2];
                    bl = false;
                }
                if (!bl) {
                    --n29;
                    bl = true;
                }
                n28 = random.nextInt(n7);
                while (Double.isNaN(this.m_MeanN[n28][i])) {
                    n28 = random.nextInt(n7);
                }
                d2 = this.m_MeanN[n28][i];
                dArray16[0] = d = (d2 - dArray16[1]) * (d2 - dArray16[1]);
                dArray16[1] = d2;
            }
        }
        this.m_LkRatio = new double[this.m_Dimension];
        if (this.m_UseEmpiricalCutOff) {
            int n30;
            double[] dArray21 = new double[n5];
            double[] dArray22 = new double[n7];
            for (n30 = 0; n30 < n5; ++n30) {
                dArray21[n30] = this.likelihoodRatio(this.m_SumP[n30], this.m_MeanP[n30]);
            }
            for (n30 = 0; n30 < n7; ++n30) {
                dArray22[n30] = this.likelihoodRatio(this.m_SumN[n30], this.m_MeanN[n30]);
            }
            this.findCutOff(dArray21, dArray22);
        } else {
            this.m_Cutoff = -Math.log((double)n5 / (double)n7);
        }
        if (this.getDebug()) {
            System.err.println("\n\n???Cut-off=" + this.m_Cutoff);
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        int n;
        Instances instances = instance.relationalValue(1);
        double[] dArray = new double[this.m_Dimension];
        double[] dArray2 = new double[this.m_Dimension];
        for (n = 0; n < instances.numAttributes(); ++n) {
            dArray2[n] = instances.meanOrMode(n);
        }
        n = 0;
        int n2 = 0;
        while (n < this.m_Dimension) {
            for (int i = 0; i < instances.numInstances(); ++i) {
                if (instances.instance(i).isMissing(n2)) continue;
                int n3 = n;
                dArray[n3] = dArray[n3] + instances.instance(i).weight();
            }
            ++n;
            ++n2;
        }
        double d = this.likelihoodRatio(dArray, dArray2);
        return d > this.m_Cutoff ? 1.0 : 0.0;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = new double[2];
        Instances instances = instance.relationalValue(1);
        double[] dArray2 = new double[this.m_Dimension];
        double[] dArray3 = new double[this.m_Dimension];
        for (n = 0; n < instances.numAttributes(); ++n) {
            dArray3[n] = instances.meanOrMode(n);
        }
        n = 0;
        int n2 = 0;
        while (n < this.m_Dimension) {
            for (int i = 0; i < instances.numInstances(); ++i) {
                if (instances.instance(i).isMissing(n2)) continue;
                int n3 = n;
                dArray2[n3] = dArray2[n3] + instances.instance(i).weight();
            }
            ++n;
            ++n2;
        }
        double d = this.likelihoodRatio(dArray2, dArray3);
        dArray[0] = 1.0 / (1.0 + Math.exp(d));
        dArray[1] = 1.0 - dArray[0];
        return dArray;
    }

    private double likelihoodRatio(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_Dimension; ++i) {
            if (Double.isNaN(dArray2[i])) continue;
            double d3 = this.m_ParamsP[2 * i];
            double d4 = this.m_ParamsP[2 * i + 1];
            double d5 = Math.log(d3 * dArray[i] + this.m_SgmSqP[i]) + dArray[i] * (d4 - dArray2[i]) * (d4 - dArray2[i]) / (d3 * dArray[i] + this.m_SgmSqP[i]);
            d -= d5;
            d3 = this.m_ParamsN[2 * i];
            d4 = this.m_ParamsN[2 * i + 1];
            double d6 = Math.log(d3 * dArray[i] + this.m_SgmSqN[i]) + dArray[i] * (d4 - dArray2[i]) * (d4 - dArray2[i]) / (d3 * dArray[i] + this.m_SgmSqN[i]);
            d2 -= d6;
            int n = i;
            this.m_LkRatio[n] = this.m_LkRatio[n] + (d5 - d6);
        }
        return d - d2 / (double)this.m_Dimension;
    }

    private void findCutOff(double[] dArray, double[] dArray2) {
        int[] nArray = Utils.sort(dArray);
        int[] nArray2 = Utils.sort(dArray2);
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = n;
        double d3 = 0.0;
        double d4 = Double.MAX_VALUE;
        while (n4 < n2 && dArray[nArray[0]] >= dArray2[nArray2[n4]]) {
            ++n4;
            d += 1.0;
        }
        if (n4 >= n2) {
            this.m_Cutoff = (dArray2[nArray2[n2 - 1]] + dArray[nArray[0]]) / 2.0;
            return;
        }
        int n5 = n4;
        while (n3 < n && n4 < n2) {
            double d5;
            if (dArray[nArray[n3]] >= dArray2[nArray2[n4]]) {
                d += 1.0;
                d5 = dArray2[nArray2[n4]];
                ++n4;
            } else {
                d2 -= 1.0;
                d5 = dArray[nArray[n3]];
                ++n3;
            }
            ++n5;
            if (!(d + d2 > d3) && (d + d2 != d3 || !(Math.abs(d5) < d4))) continue;
            d3 = d + d2;
            this.m_Cutoff = d5;
            d4 = Math.abs(d5);
        }
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSet whether or not use empirical\n\tlog-odds cut-off instead of 0", "C", 0, "-C"));
        vector.addElement(new Option("\tSet the number of multiple runs \n\tneeded for searching the MLE.", "R", 1, "-R <numOfRuns>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        this.setUsingCutOff(Utils.getFlag('C', stringArray));
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setNumRuns(Integer.parseInt(string));
        } else {
            this.setNumRuns(1);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getDebug()) {
            vector.add("-D");
        }
        if (this.getUsingCutOff()) {
            vector.add("-C");
        }
        vector.add("-R");
        vector.add("" + this.getNumRuns());
        return vector.toArray(new String[vector.size()]);
    }

    public String numRunsTipText() {
        return "The number of runs to perform.";
    }

    public void setNumRuns(int n) {
        this.m_Run = n;
    }

    public int getNumRuns() {
        return this.m_Run;
    }

    public String usingCutOffTipText() {
        return "Whether to use an empirical cutoff.";
    }

    public void setUsingCutOff(boolean bl) {
        this.m_UseEmpiricalCutOff = bl;
    }

    public boolean getUsingCutOff() {
        return this.m_UseEmpiricalCutOff;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n\nTLDSimple:\n");
        int n = 0;
        int n2 = 0;
        while (n < this.m_Dimension) {
            double d = this.m_SgmSqP[n];
            double d2 = this.m_ParamsP[2 * n];
            double d3 = this.m_ParamsP[2 * n + 1];
            stringBuffer.append("\n" + this.m_Attribute.attribute(n2).name() + "\nPositive: " + "sigma^2=" + d + ", w=" + d2 + ", m=" + d3 + "\n");
            d = this.m_SgmSqN[n];
            d2 = this.m_ParamsN[2 * n];
            d3 = this.m_ParamsN[2 * n + 1];
            stringBuffer.append("Negative: sigma^2=" + d + ", w=" + d2 + ", m=" + d3 + "\n");
            ++n;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        TLDSimple.runClassifier(new TLDSimple(), stringArray);
    }
}

