/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCBA;

import java.io.IOException;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Apriori;
import keel.Algorithms.Associative_Classification.ClassifierCBA.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCBA.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierCBA.myDataset;
import keel.Algorithms.Associative_Classification.ClassifierCBA.parseParameters;
import org.core.Files;

public class CBA {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String fileDB;
    String fileRB;
    String fileTime;
    String fileHora;
    String data;
    DataBase dataBase;
    RuleBase ruleBase;
    RuleBase CAR;
    Apriori apriori;
    long startTime;
    long totalTime;
    double minsup;
    double minconf;
    int isPrune;
    int limitRules;
    private boolean somethingWrong = false;

    public CBA() {
    }

    public CBA(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.train.hasMissingAttributes();
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.fileDB = parameters.getOutputFile(0);
        this.fileRB = parameters.getOutputFile(1);
        this.data = parameters.getTrainingInputFile();
        this.fileTime = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/hora.txt";
        this.minsup = Double.parseDouble(parameters.getParameter(0));
        this.minconf = Double.parseDouble(parameters.getParameter(1));
        this.isPrune = Integer.parseInt(parameters.getParameter(2));
        this.limitRules = Integer.parseInt(parameters.getParameter(3));
        if (this.limitRules < 1) {
            this.limitRules = Integer.MAX_VALUE;
        }
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, either the data-set has missing values.");
            System.err.println("Please remove the examples with missing data or apply a MV preprocessing.");
            System.err.println("Aborting the program");
        } else {
            this.dataBase = new DataBase(this.train);
            this.apriori = new Apriori(this.dataBase, this.train, this.minsup, this.minconf, this.isPrune, this.limitRules);
            this.CAR = this.apriori.generateCAR();
            System.out.println("\nNumber of rule generated in Apriori: " + this.CAR.size());
            this.CAR.CBACBM2();
            this.ruleBase = this.CAR.getClassifier();
            this.dataBase.saveFile(this.fileDB);
            this.ruleBase.saveFile(this.fileRB);
            this.doOutput(this.val, this.outputTr);
            this.doOutput(this.test, this.outputTst);
            this.totalTime = System.currentTimeMillis() - this.startTime;
            this.writeTime();
            System.out.println("Algorithm Finished");
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.data + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.data + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void doOutput(myDataset dataset, String filename) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.getnData(); ++i) {
            output = output + dataset.getOutputAsString(i) + " " + this.classificationOutput(dataset.getExample(i)) + "\n";
        }
        Files.writeFile(filename, output);
    }

    private String classificationOutput(int[] example) {
        String output = new String("?");
        int clas = this.ruleBase.FRM(example);
        if (clas >= 0) {
            output = this.train.getOutputValue(clas);
        }
        return output;
    }
}

