/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.MixtGauss;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class MixtGaussGenerator
extends PrototypeGenerator {
    private int numberOfGaussians;
    protected int numberOfPrototypes;
    protected int numberOfClass;

    public MixtGaussGenerator(PrototypeSet _trainingDataSet, int blocks, String choice) {
        super(_trainingDataSet);
        this.algorithmName = "MixtGauss";
    }

    public MixtGaussGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "MixtGauss";
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        this.numberOfGaussians = parameters.getNextAsInt();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.numberOfGaussians);
        this.numberOfGaussians = this.numberOfPrototypes / this.numberOfClass;
        if (this.numberOfGaussians == 0) {
            this.numberOfGaussians = 1;
        }
    }

    public double pdfNormal(double x) {
        double result = 1.0 / Math.sqrt(Math.PI * 2);
        return result *= Math.exp(-0.5 * (x * x));
    }

    public double f_x(double x, double mu, double sigma) {
        double result = 1.0 / sigma;
        return result * this.pdfNormal((x - mu) / sigma);
    }

    public double[] CalculateAccuracy(PrototypeSet actual) {
        double[] current_accuracy = new double[this.numberOfClass];
        for (int i = 0; i < this.numberOfClass; ++i) {
            current_accuracy[i] = actual.getFromClass(i).size() > 0 ? MixtGaussGenerator.accuracy(actual.getFromClass(i), this.trainingDataSet.getFromClass(i)) : 0.0;
        }
        return current_accuracy;
    }

    public Pair<PrototypeSet, PrototypeSet> EMstep(PrototypeSet actual, PrototypeSet SD) {
        for (int j = 0; j < actual.size(); ++j) {
            ((Prototype)actual.get(j)).setIndex(j);
        }
        double[][] pdfs = new double[this.numberOfGaussians][];
        double[][] pdfsNum = new double[this.numberOfGaussians][];
        double acc = MixtGaussGenerator.accuracy(actual, this.trainingDataSet);
        double acc2 = acc - 1.0;
        double[] alfaMj = new double[this.numberOfGaussians];
        for (int j = 0; j < this.numberOfGaussians; ++j) {
            alfaMj[j] = 1.0 / (double)this.numberOfGaussians;
        }
        for (int i = 0; i < this.numberOfClass; ++i) {
            PrototypeSet perClass = this.trainingDataSet.getFromClass(i);
            if (perClass.size() <= 0) continue;
            acc2 = acc - 1.0;
            while (acc > acc2) {
                int j;
                acc2 = acc;
                double[] sumPDFS = new double[perClass.size()];
                for (int j2 = 0; j2 < this.numberOfGaussians; ++j2) {
                    pdfs[j2] = new double[perClass.size()];
                    pdfsNum[j2] = new double[perClass.size()];
                }
                for (int t = 0; t < perClass.size(); ++t) {
                    int j3;
                    sumPDFS[t] = 0.0;
                    for (j3 = 0; j3 < this.numberOfGaussians; ++j3) {
                        double productorio = 1.0;
                        for (int k = 0; k < ((Prototype)perClass.get(0)).numberOfInputs(); ++k) {
                            double value = this.f_x(((Prototype)perClass.get(t)).getInput(k), ((Prototype)actual.getFromClass(i).get(j3)).getInput(k), ((Prototype)SD.getFromClass(i).get(j3)).getInput(k));
                            productorio *= value;
                        }
                        pdfsNum[j3][t] = alfaMj[j3] * productorio * 1.0;
                        int n = t;
                        sumPDFS[n] = sumPDFS[n] + pdfsNum[j3][t];
                    }
                    for (j3 = 0; j3 < this.numberOfGaussians; ++j3) {
                        pdfs[j3][t] = pdfsNum[j3][t] / sumPDFS[t];
                    }
                }
                double sum = 0.0;
                int j4 = 0;
                while (j4 < this.numberOfGaussians) {
                    sum = 0.0;
                    alfaMj[j4] = 1.0 / (double)perClass.size();
                    for (int t = 0; t < perClass.size(); ++t) {
                        sum += pdfs[j4][t];
                    }
                    int n = j4++;
                    alfaMj[n] = alfaMj[n] * sum;
                }
                PrototypeSet nuevo = new PrototypeSet(actual);
                double denominator = 0.0;
                double[][] numerator = new double[((Prototype)perClass.get(0)).numberOfInputs()][this.numberOfGaussians];
                for (int k = 0; k < ((Prototype)perClass.get(0)).numberOfInputs(); ++k) {
                    for (j = 0; j < this.numberOfGaussians; ++j) {
                        numerator[k][j] = 0.0;
                    }
                }
                for (int j5 = 0; j5 < this.numberOfGaussians; ++j5) {
                    int k;
                    denominator = 0.0;
                    for (int t = 0; t < perClass.size(); ++t) {
                        for (k = 0; k < ((Prototype)perClass.get(0)).numberOfInputs(); ++k) {
                            double[] dArray = numerator[k];
                            int n = j5;
                            dArray[n] = dArray[n] + pdfs[j5][t] * ((Prototype)perClass.get(t)).getInput(k);
                        }
                        denominator += pdfs[j5][t];
                    }
                    Prototype element = new Prototype((Prototype)perClass.get(0));
                    for (k = 0; k < ((Prototype)perClass.get(0)).numberOfInputs(); ++k) {
                        double media = numerator[k][j5] / (denominator * 1.0);
                        element.setInput(k, media);
                    }
                    int index = ((Prototype)actual.getFromClass(i).get(j5)).getIndex();
                    nuevo.set(index, element);
                }
                PrototypeSet newSD = new PrototypeSet(SD);
                for (int k = 0; k < ((Prototype)perClass.get(0)).numberOfInputs(); ++k) {
                    for (int j6 = 0; j6 < this.numberOfGaussians; ++j6) {
                        numerator[k][j6] = 0.0;
                    }
                }
                for (j = 0; j < this.numberOfGaussians; ++j) {
                    int k;
                    denominator = 0.0;
                    for (int t = 0; t < perClass.size(); ++t) {
                        for (k = 0; k < ((Prototype)perClass.get(0)).numberOfInputs(); ++k) {
                            int index = ((Prototype)actual.getFromClass(i).get(j)).getIndex();
                            double[] dArray = numerator[k];
                            int n = j;
                            dArray[n] = dArray[n] + pdfs[j][t] * Math.pow(((Prototype)perClass.get(t)).getInput(k) - ((Prototype)nuevo.get(index)).getInput(k), 2.0);
                        }
                        denominator += pdfs[j][t];
                    }
                    Prototype element = new Prototype((Prototype)perClass.get(0));
                    for (k = 0; k < ((Prototype)perClass.get(0)).numberOfInputs(); ++k) {
                        double media = numerator[k][j] / (denominator * 1.0);
                        element.setInput(k, media);
                    }
                    int index = ((Prototype)actual.getFromClass(i).get(j)).getIndex();
                    SD.set(index, element);
                }
                acc = MixtGaussGenerator.accuracy(nuevo, this.trainingDataSet);
                if (!(acc > acc2)) continue;
                actual = new PrototypeSet(nuevo);
                for (j = 0; j < actual.size(); ++j) {
                    ((Prototype)actual.get(j)).setIndex(j);
                }
                SD = new PrototypeSet(newSD);
            }
        }
        Pair<PrototypeSet, PrototypeSet> salida = new Pair<PrototypeSet, PrototypeSet>(actual, SD);
        return salida;
    }

    @Override
    public PrototypeSet reduceSet() {
        System.out.print("\nThe algorithm MixtGauss is starting...\n Computing...\n");
        PrototypeSet result = new PrototypeSet();
        Prototype mean = new Prototype();
        PrototypeSet SD = new PrototypeSet();
        for (int i = 0; i < this.numberOfClass; ++i) {
            PrototypeSet classi = this.trainingDataSet.getFromClass(i);
            if (classi.size() <= 0) continue;
            mean = classi.avg();
            for (int j = 0; j < this.numberOfGaussians; ++j) {
                Prototype Perturbance = new Prototype(mean);
                Prototype sdP = new Prototype(mean);
                for (int k = 0; k < Perturbance.numberOfInputs(); ++k) {
                    Perturbance.setInput(k, mean.getInput(k) + RandomGenerator.Randdouble(-0.01, 0.01));
                    sdP.setInput(k, 0.1);
                }
                result.add(Perturbance);
                SD.add(sdP);
            }
        }
        result.applyThresholds();
        double[] current_accuracy = new double[this.numberOfClass];
        current_accuracy = this.CalculateAccuracy(result);
        double classes_improve = -1.0;
        PrototypeSet PreviousGaussians = new PrototypeSet();
        double[] previous_accuracy = new double[this.numberOfClass];
        while (classes_improve != 0.0) {
            PreviousGaussians = new PrototypeSet(result);
            Pair<PrototypeSet, PrototypeSet> salidaR = this.EMstep(PreviousGaussians, SD);
            result = salidaR.first();
            SD = salidaR.second();
            previous_accuracy = current_accuracy;
            current_accuracy = this.CalculateAccuracy(result);
            classes_improve = 0.0;
            for (int c = 0; c < this.numberOfClass; ++c) {
                if (current_accuracy[c] > previous_accuracy[c]) {
                    classes_improve += 1.0;
                    continue;
                }
                if (!(current_accuracy[c] < previous_accuracy[c])) continue;
                for (int g = 0; g < this.numberOfGaussians; ++g) {
                    int index = c * this.numberOfGaussians + g;
                    result.set(index, PreviousGaussians.get(index));
                }
            }
        }
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(result);
        System.err.println("\n% de acierto en training Nominal " + (double)KNN.classficationAccuracy(nominalPopulation, this.trainingDataSet, 1) * 100.0 / (double)this.trainingDataSet.size());
        return result;
    }

    public static void main(String[] args) {
        Parameters.setUse("MixtGauss", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        MixtGaussGenerator.setSeed(seed);
        int blocks = Parameters.assertExtendedArgAsInt(args, 10, "number of blocks", 1.0, 2.147483647E9);
        MixtGaussGenerator generator = new MixtGaussGenerator(training, blocks, "diameter");
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

