/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.RestrictionConnectiveDescr;
import org.drools.compiler.lang.descr.RestrictionDescr;
import org.kie.api.io.Resource;

public class FieldConstraintDescr
extends BaseDescr {
    private static final long serialVersionUID = 510L;
    private String fieldName;
    private RestrictionConnectiveDescr restriction = new RestrictionConnectiveDescr(RestrictionConnectiveDescr.AND);

    public FieldConstraintDescr() {
    }

    public FieldConstraintDescr(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.fieldName = (String)in.readObject();
        this.restriction = (RestrictionConnectiveDescr)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.fieldName);
        out.writeObject(this.restriction);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void addRestriction(RestrictionDescr restriction) {
        this.restriction.addRestriction(restriction);
    }

    public List getRestrictions() {
        return this.restriction.getRestrictions();
    }

    public RestrictionConnectiveDescr getRestriction() {
        return this.restriction;
    }

    @Override
    public void setResource(Resource resource) {
        super.setResource(resource);
        this.restriction.setResource(resource);
    }

    public String toString() {
        return this.fieldName + " " + this.restriction;
    }
}

