/*
 * Decompiled with CFR 0.152.
 */
package vu.co.kaiyin;

import com.sun.istack.internal.NotNull;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;

public class GenoBytes {
    public static final int[][] defaultCollapseMatrix = new int[][]{{0, 0, 0, 0}, {0, 1, 1, 1}, {0, 1, 0, 3}, {0, 1, 3, 3}};
    public static final int[][] antiDiagonal = new int[][]{{3, 1, 3, 0}, {1, 1, 1, 1}, {3, 1, 0, 3}, {0, 1, 3, 3}};

    public static byte genoByte(byte b1, byte b2, byte b3, byte b4) {
        if (!(GenoBytes.rightByte(b1) && GenoBytes.rightByte(b2) && GenoBytes.rightByte(b3) && GenoBytes.rightByte(b4))) {
            throw new InvalidParameterException("genotype should be between 0 and 3 (inclusive)");
        }
        return (byte)(b1 << 6 | b2 << 4 | b3 << 2 | b4);
    }

    @NotNull
    public static byte genoByte(@NotNull byte[] bytes) {
        if (bytes.length != 4) {
            throw new InvalidParameterException("bytes must be of length 4");
        }
        return GenoBytes.genoByte(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    public static byte genoByte(int b1, int b2, int b3, int b4) {
        return GenoBytes.genoByte((byte)b1, (byte)b2, (byte)b3, (byte)b4);
    }

    public static byte genoByte(int[] genoIntegers) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)genoIntegers[i];
        }
        return GenoBytes.genoByte(bytes);
    }

    public static boolean rightByte(byte b) {
        return b >= 0 && b < 4;
    }

    public static boolean rightGeno(int g) {
        return g >= 0 && g < 4;
    }

    public static int[] byteGeno(byte b) {
        int i1 = (b & 0xC0) >> 6;
        int i2 = (b & 0x30) >> 4;
        int i3 = (b & 0xC) >> 2;
        int i4 = b & 3;
        return new int[]{i1, i2, i3, i4};
    }

    public static int collapse(int geno1, int geno2, int[][] collapseMatrix) {
        if (collapseMatrix.length != 4 || collapseMatrix[0].length != 4 || collapseMatrix[1].length != 4 || collapseMatrix[2].length != 4 || collapseMatrix[3].length != 4) {
            throw new InvalidParameterException("collapse matrix must be 4x4");
        }
        if (!GenoBytes.rightGeno(geno1) || !GenoBytes.rightGeno(geno2)) {
            throw new InvalidParameterException("genotype must be between 0 and 3 (inclusive)");
        }
        return collapseMatrix[geno1][geno2];
    }

    public static int collapse(int geno1, int geno2) {
        return GenoBytes.collapse(geno1, geno2, defaultCollapseMatrix);
    }

    public static int[] collapse(int[] genoArray1, int[] genoArray2, int[][] collapseMatrix) {
        if (genoArray1.length != genoArray2.length) {
            throw new InvalidParameterException("genoArray1 and genoArray2 must be of the same length");
        }
        int[] gCollapsed = new int[genoArray1.length];
        for (int i = 0; i < genoArray1.length; ++i) {
            gCollapsed[i] = GenoBytes.collapse(genoArray1[i], genoArray2[i], collapseMatrix);
        }
        return gCollapsed;
    }

    public static int[] collapse(int[] genoArray1, int[] genoArray2) {
        return GenoBytes.collapse(genoArray1, genoArray2, defaultCollapseMatrix);
    }

    public static int[] collapse(byte b1, byte b2) {
        return GenoBytes.collapse(GenoBytes.byteGeno(b1), GenoBytes.byteGeno(b2));
    }

    public static int[] collapse(byte b1, byte b2, int[][] collapseMatrix) {
        return GenoBytes.collapse(GenoBytes.byteGeno(b1), GenoBytes.byteGeno(b2), collapseMatrix);
    }

    public static byte[] collapse(byte[] bs1, byte[] bs2, int[][] collapseMatrix) {
        if (bs1.length != bs2.length) {
            throw new InvalidParameterException("bs1 and bs2 must be of the same length");
        }
        byte[] collapsedBytes = new byte[bs1.length];
        for (int i = 0; i < bs1.length; ++i) {
            collapsedBytes[i] = GenoBytes.genoByte(GenoBytes.collapse(bs1[i], bs2[i], collapseMatrix));
        }
        return collapsedBytes;
    }

    public static byte[] collapse(byte[] bs1, byte[] bs2) {
        return GenoBytes.collapse(bs1, bs2, defaultCollapseMatrix);
    }

    public static void main(String[] args) throws IOException {
        byte b = GenoBytes.genoByte(new int[]{1, 3, 0, 2});
        FileOutputStream fileOutputStream = new FileOutputStream("/tmp/x.bin");
        fileOutputStream.write(new byte[]{b});
        System.out.println(true);
    }
}

