## ---- echo = FALSE-------------------------------------------------------
library(knitLatex)
knitr::opts_chunk$set(collapse = TRUE)
cars  <- mtcars[1:10,1:5]

## ------------------------------------------------------------------------
lTab(cars)

## ------------------------------------------------------------------------
lTab(cars, label = 'tab:mytable')

## ------------------------------------------------------------------------
lTab(cars, caption.head = 'my caption in head')

## ------------------------------------------------------------------------
lTab(cars,
     firsthead = 'f1 & f2 & f3 & f4 & f5 \\\\',
     caption.firsthead = 'my caption in firsthead')

## ------------------------------------------------------------------------
lTab(cars, caption.foot = 'my caption in foot')

## ------------------------------------------------------------------------
lTab(cars,
     lastfoot = '\\hline',
     caption.lastfoot = 'my caption in last foot')

## ------------------------------------------------------------------------
lTab(cars, booktabs = TRUE)

## ------------------------------------------------------------------------
lTab(cars, booktabs = TRUE, midrule = '\\hline')

## ------------------------------------------------------------------------
lTab(cars,
     head = 'col1 & col 2 & col3 & \\eta & col5 \\\\')

## ------------------------------------------------------------------------
lTab(cars, head = NULL)

## ------------------------------------------------------------------------
lTab(cars, head = '', midrule = NULL)

## ------------------------------------------------------------------------
lTab(cars,
     firsthead = 'f1 & f2 & f3 & f4 & f5 \\\\')

## ------------------------------------------------------------------------
lTab(cars, toprule = NULL, midrule = NULL,
     firsthead = '\\toprule\nf1 & f2 & f3 & f4 & f5 \\\\\nmidrule',
     head = '\\hline\n col1 & col2 & col3 & cll4 & col5 \\\\\n\\hline')

## ------------------------------------------------------------------------
lTab(cars, toprule = NULL, midrule = NULL,
     firsthead = '\\toprule\nf1 & f2 & f3 & f4 & f5 \\\\\nmidrule',
     head = '\\toprule')

## ------------------------------------------------------------------------
lTab(cars, rows = TRUE)

## ------------------------------------------------------------------------
lTab(cars,
     rows =  TRUE,
     head = 'rows & col1 & col2 & col3 & \\eta & col5 \\\\')

## ------------------------------------------------------------------------
lTab(cars, rowsep = '\\hline')

## ------------------------------------------------------------------------
lTab(cars, rowsep = '\\midrule')

## ------------------------------------------------------------------------
lTab(cars, coldef ='rlc|l|p{5cm}')

## ------------------------------------------------------------------------
lTab(cars, colsep = '|')

