## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
options(rmarkdown.html_vignette.check_title = FALSE)

## ----setup, include = FALSE---------------------------------------------------
library(panelhetero)

## ---- eval = FALSE------------------------------------------------------------
#  # install.packages("devtools") # if necessary
#  # install.packages("ggplot2")  # if necessary
#  devtools::install_github("tkhdyanagi/panelhetero", build_vignettes = TRUE)

## ---- eval = TRUE-------------------------------------------------------------
set.seed(1)

y <- panelhetero::simulation(N = 300, S = 50)

## ---- eval = TRUE-------------------------------------------------------------
set.seed(1)

result1 <- panelhetero::hpjmoment(data = y, acov_order = 0, acor_order = 1)
result1$estimate
result1$se
result1$ci

## ---- eval = TRUE-------------------------------------------------------------
result2 <- panelhetero::hpjecdf(data = y, 
                                acov_order = 0, 
                                acor_order = 1,
                                R = 100,
                                ci = FALSE)
result2$mean

## ---- eval = TRUE-------------------------------------------------------------
result3 <- panelhetero::hpjkd(data = y, acov_order = 0, acor_order = 1)
result3$mean

## ---- eval = TRUE-------------------------------------------------------------
result3$mean + 
  ggplot2::ggtitle("") + 
  ggplot2::theme_classic()

## ---- eval = TRUE-------------------------------------------------------------
ggplot2::ggplot(data = data.frame(x = c(-3.5, 3.5)), ggplot2::aes(x = x)) + 
  ggplot2::stat_function(fun = result3$mean_func) + 
  ggplot2::ggtitle("")

