/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.validate;

import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.dict.DictionaryDatabase;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.validate.AbstractValidator;
import org.openscience.cdk.validate.ValidationReport;
import org.openscience.cdk.validate.ValidationTest;

public class DictionaryValidator
extends AbstractValidator {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DictionaryValidator.class);
    private final DictionaryDatabase db;

    public DictionaryValidator(DictionaryDatabase db) {
        this.db = db;
    }

    @Override
    public ValidationReport validateChemObject(IChemObject subject) {
        ValidationReport report = new ValidationReport();
        Map properties = subject.getProperties();
        Iterator iter = properties.keySet().iterator();
        ValidationTest noNamespace = new ValidationTest(subject, "Dictionary Reference lacks a namespace indicating the dictionary.");
        ValidationTest noDict = new ValidationTest(subject, "The referenced dictionary does not exist.");
        ValidationTest noEntry = new ValidationTest(subject, "The referenced entry does not exist in the dictionary.");
        while (iter.hasNext()) {
            String keyName;
            Object key = iter.next();
            if (!(key instanceof String) || !(keyName = (String)key).startsWith("org.openscience.cdk.dict")) continue;
            String dictRef = (String)properties.get(keyName);
            String details = "Dictref being anaylyzed: " + dictRef + ". ";
            noNamespace.setDetails(details);
            noDict.setDetails(details);
            noEntry.setDetails(details);
            int index = dictRef.indexOf(58);
            if (index != -1) {
                report.addOK(noNamespace);
                String dict = dictRef.substring(0, index);
                logger.debug((Object)("Looking for dictionary:" + dict));
                if (this.db.hasDictionary(dict)) {
                    report.addOK(noDict);
                    if (dictRef.length() > index + 1) {
                        String entry = dictRef.substring(index + 1);
                        logger.debug((Object)("Looking for entry:" + entry));
                        if (this.db.hasEntry(dict, entry)) {
                            report.addOK(noEntry);
                            continue;
                        }
                        report.addError(noEntry);
                        continue;
                    }
                    report.addError(noEntry);
                    continue;
                }
                details = details + "The dictionary searched: " + dict + ".";
                noDict.setDetails(details);
                report.addError(noDict);
                report.addError(noEntry);
                continue;
            }
            details = details + "There is not a namespace given.";
            noNamespace.setDetails(details);
            report.addError(noNamespace);
            report.addError(noDict);
            report.addError(noEntry);
        }
        return report;
    }
}

