/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.similarity;

import java.util.Map;
import java.util.TreeSet;

public class LingoSimilarity {
    private LingoSimilarity() {
    }

    public static float calculate(Map<String, Integer> features1, Map<String, Integer> features2) {
        TreeSet<String> keys = new TreeSet<String>(features1.keySet());
        keys.addAll(features2.keySet());
        if (keys.isEmpty()) {
            return 1.0f;
        }
        double res = 0.0;
        for (String key : keys) {
            int count1 = features1.getOrDefault(key, 0);
            int count2 = features2.getOrDefault(key, 0);
            int diff = Math.abs(count1 - count2);
            int sum = count1 + count2;
            if (sum == 0) continue;
            res += 1.0 - (double)diff / (double)sum;
        }
        return (float)(res / (double)keys.size());
    }
}

