/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.clauses.ClauseBuilder;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class PropSum
extends Propagator<IntVar> {
    protected final int pos;
    protected final int l;
    protected final int b;
    protected final int[] I;
    protected int maxI;
    protected int sumLB;
    protected int sumUB;
    protected final Operator o;

    public PropSum(IntVar[] variables, int pos, Operator o, int b) {
        this(variables, pos, o, b, PropSum.computePriority(variables.length), false);
    }

    PropSum(IntVar[] variables, int pos, Operator o, int b, PropagatorPriority priority, boolean reactOnFineEvent) {
        super((Variable[])variables, (Priority)priority, reactOnFineEvent);
        this.pos = pos;
        this.o = o;
        this.b = b;
        this.l = variables.length;
        this.I = new int[this.l];
        this.maxI = 0;
    }

    protected static PropagatorPriority computePriority(int nbvars) {
        if (nbvars == 1) {
            return PropagatorPriority.UNARY;
        }
        if (nbvars == 2) {
            return PropagatorPriority.BINARY;
        }
        if (nbvars == 3) {
            return PropagatorPriority.TERNARY;
        }
        return PropagatorPriority.LINEAR;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        switch (this.o) {
            case NQ: {
                return IntEventType.instantiation();
            }
            case LE: {
                return IntEventType.combine(IntEventType.INSTANTIATE, vIdx < this.pos ? IntEventType.INCLOW : IntEventType.DECUPP);
            }
            case GE: {
                return IntEventType.combine(IntEventType.INSTANTIATE, vIdx < this.pos ? IntEventType.DECUPP : IntEventType.INCLOW);
            }
        }
        return IntEventType.boundAndInst();
    }

    protected void prepare() {
        int ub;
        int lb;
        int i;
        this.sumUB = 0;
        this.sumLB = 0;
        this.maxI = 0;
        for (i = 0; i < this.pos; ++i) {
            lb = ((IntVar[])this.vars)[i].getLB();
            ub = ((IntVar[])this.vars)[i].getUB();
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI >= this.I[i]) continue;
            this.maxI = this.I[i];
        }
        while (i < this.l) {
            lb = -((IntVar[])this.vars)[i].getUB();
            ub = -((IntVar[])this.vars)[i].getLB();
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI < this.I[i]) {
                this.maxI = this.I[i];
            }
            ++i;
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    protected void filter() throws ContradictionException {
        this.prepare();
        switch (this.o) {
            case LE: {
                this.filterOnLeq();
                break;
            }
            case GE: {
                this.filterOnGeq();
                break;
            }
            case NQ: {
                this.filterOnNeq();
                break;
            }
            default: {
                this.filterOnEq();
            }
        }
    }

    protected void filterOnEq() throws ContradictionException {
        boolean anychange;
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        do {
            anychange = false;
            if (this.model.getSolver().isLearnOff() && (F2 < 0 || E < 0)) {
                this.fails();
            }
            if (this.maxI > F2 || this.maxI > E) {
                int nlb;
                int nub;
                int ub;
                int lb;
                int i;
                this.maxI = 0;
                for (i = 0; i < this.pos; ++i) {
                    if (this.I[i] - F2 > 0) {
                        lb = ((IntVar[])this.vars)[i].getLB();
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound(F2 + lb, (ICause)this)) {
                            nub = ((IntVar[])this.vars)[i].getUB();
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0) {
                        ub = ((IntVar[])this.vars)[i].getUB();
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(ub - E, (ICause)this)) {
                            nlb = ((IntVar[])this.vars)[i].getLB();
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI >= this.I[i]) continue;
                    this.maxI = this.I[i];
                }
                while (i < this.l) {
                    if (this.I[i] - F2 > 0) {
                        lb = -((IntVar[])this.vars)[i].getUB();
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(-F2 - lb, (ICause)this)) {
                            nub = -((IntVar[])this.vars)[i].getLB();
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0) {
                        ub = -((IntVar[])this.vars)[i].getLB();
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound(-ub + E, (ICause)this)) {
                            nlb = -((IntVar[])this.vars)[i].getUB();
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI < this.I[i]) {
                        this.maxI = this.I[i];
                    }
                    ++i;
                }
            }
            if (F2 > 0 || E > 0) continue;
            this.setPassive();
            return;
        } while (anychange);
    }

    protected void filterOnLeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (this.model.getSolver().isLearnOff() && F2 < 0) {
            this.fails();
        }
        if (this.maxI > F2) {
            int nub;
            int ub;
            int lb;
            int i;
            this.maxI = 0;
            for (i = 0; i < this.pos; ++i) {
                if (this.I[i] - F2 > 0) {
                    lb = ((IntVar[])this.vars)[i].getLB();
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(F2 + lb, (ICause)this)) {
                        nub = ((IntVar[])this.vars)[i].getUB();
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - F2 > 0) {
                    lb = -((IntVar[])this.vars)[i].getUB();
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(-F2 - lb, (ICause)this)) {
                        nub = -((IntVar[])this.vars)[i].getLB();
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (E <= 0) {
            this.setPassive();
        }
    }

    protected void filterOnGeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (this.model.getSolver().isLearnOff() && E < 0) {
            this.fails();
        }
        if (this.maxI > E) {
            int nlb;
            int lb;
            int ub;
            int i;
            this.maxI = 0;
            for (i = 0; i < this.pos; ++i) {
                if (this.I[i] - E > 0) {
                    ub = ((IntVar[])this.vars)[i].getUB();
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(ub - E, (ICause)this)) {
                        nlb = ((IntVar[])this.vars)[i].getLB();
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - E > 0) {
                    ub = -((IntVar[])this.vars)[i].getLB();
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(-ub + E, (ICause)this)) {
                        nlb = -((IntVar[])this.vars)[i].getUB();
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (F2 <= 0) {
            this.setPassive();
        }
    }

    protected void filterOnNeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (F2 < 0 || E < 0) {
            this.setPassive();
            return;
        }
        int w = -1;
        int sum = 0;
        for (int i = 0; i < this.l; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                sum += i < this.pos ? ((IntVar[])this.vars)[i].getValue() : -((IntVar[])this.vars)[i].getValue();
                continue;
            }
            if (w == -1) {
                w = i;
                continue;
            }
            return;
        }
        if (w == -1) {
            if (sum == this.b) {
                this.fails();
            }
        } else {
            ((IntVar[])this.vars)[w].removeValue(w < this.pos ? this.b - sum : sum - this.b, (ICause)this);
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        int sumUB = 0;
        int sumLB = 0;
        for (i = 0; i < this.pos; ++i) {
            sumLB += ((IntVar[])this.vars)[i].getLB();
            sumUB += ((IntVar[])this.vars)[i].getUB();
        }
        while (i < this.l) {
            sumLB -= ((IntVar[])this.vars)[i].getUB();
            sumUB -= ((IntVar[])this.vars)[i].getLB();
            ++i;
        }
        return this.check(sumLB, sumUB);
    }

    public ESat check(int sumLB, int sumUB) {
        switch (this.o) {
            case NQ: {
                if (sumUB < this.b || sumLB > this.b) {
                    return ESat.TRUE;
                }
                if (sumUB == this.b && sumLB == this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            case LE: {
                if (sumUB <= this.b) {
                    return ESat.TRUE;
                }
                if (sumLB > this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            case GE: {
                if (sumLB >= this.b) {
                    return ESat.TRUE;
                }
                if (sumUB < this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
        }
        if (sumLB == this.b && sumUB == this.b) {
            return ESat.TRUE;
        }
        if (sumUB < this.b || sumLB > this.b) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        if (this.o == Operator.NQ) {
            Propagator.defaultExplain(this, p, explanation);
        } else {
            this.doExplain(explanation, p);
        }
    }

    void doExplain(ExplanationForSignedClause explanation, int p) {
        int max;
        int min;
        int ub;
        int lb;
        IntIterableRangeSet dom_before;
        int i;
        IntVar pivot = explanation.readVar(p);
        int sumLB = 0;
        int sumUB = 0;
        int la = 0;
        int ua = 0;
        int a2 = 0;
        int ca = 0;
        for (i = 0; i < this.pos; ++i) {
            dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            lb = dom_before.min();
            ub = dom_before.max();
            if (((IntVar[])this.vars)[i] == pivot) {
                la = dom_before.min();
                ua = dom_before.max();
                a2 = i;
                ca = 1;
            }
            sumLB += lb;
            sumUB += ub;
        }
        while (i < this.l) {
            dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            lb = -dom_before.max();
            ub = -dom_before.min();
            if (((IntVar[])this.vars)[i] == pivot) {
                la = dom_before.min();
                ua = dom_before.max();
                a2 = i;
                ca = -1;
            }
            sumLB += lb;
            sumUB += ub;
            ++i;
        }
        int F2 = this.b - sumLB;
        int E = sumUB - this.b;
        if (explanation.readDom(p).isEmpty()) {
            this.doExplainGlobalFailure(explanation, F2, E);
            return;
        }
        int la2 = -1073741823;
        int ua2 = 0x3FFFFFFF;
        if (a2 < this.pos) {
            if (!this.o.equals((Object)Operator.GE)) {
                ua2 = F2 + la;
            }
            if (!this.o.equals((Object)Operator.LE)) {
                la2 = ua - E;
            }
        } else {
            if (!this.o.equals((Object)Operator.GE)) {
                la2 = -F2 + ua;
            }
            if (!this.o.equals((Object)Operator.LE)) {
                ua2 = la + E;
            }
        }
        IntIterableRangeSet domain = explanation.empty();
        if (la2 <= ua2) {
            domain.addBetween(la2, ua2);
        }
        ((IntVar[])this.vars)[a2].intersectLit(domain, explanation);
        for (i = 0; i < this.pos; ++i) {
            min = -1073741823;
            max = 0x3FFFFFFF;
            if (((IntVar[])this.vars)[i] == pivot) continue;
            dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            if (!this.o.equals((Object)Operator.GE)) {
                max = F2 + dom_before.min() - ca * (ca > 0 ? ua2 + 1 - la : la2 - 1 - ua);
            }
            if (!this.o.equals((Object)Operator.LE)) {
                min = -E + dom_before.max() - ca * (ca > 0 ? la2 - 1 - ua : ua2 + 1 - la);
            }
            domain = explanation.complement(((IntVar[])this.vars)[i]);
            if (this.o.equals((Object)Operator.EQ)) {
                assert (max + 1 <= min - 1) : "empty range";
                domain.removeBetween(max + 1, min - 1);
            } else {
                domain.retainBetween(min, max);
            }
            ((IntVar[])this.vars)[i].unionLit(domain, explanation);
        }
        while (i < this.l) {
            min = -1073741823;
            max = 0x3FFFFFFF;
            if (((IntVar[])this.vars)[i] != pivot) {
                dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
                if (!this.o.equals((Object)Operator.GE)) {
                    min = -(F2 - dom_before.max() - ca * (ca > 0 ? ua2 + 1 - la : la2 - 1 - ua));
                }
                if (!this.o.equals((Object)Operator.LE)) {
                    max = -(-E - dom_before.min() - ca * (ca > 0 ? la2 - 1 - ua : ua2 + 1 - la));
                }
                domain = explanation.complement(((IntVar[])this.vars)[i]);
                if (this.o.equals((Object)Operator.EQ)) {
                    assert (max + 1 <= min - 1) : "empty range";
                    domain.removeBetween(max + 1, min - 1);
                } else {
                    domain.retainBetween(min, max);
                }
                ((IntVar[])this.vars)[i].unionLit(domain, explanation);
            }
            ++i;
        }
    }

    void doExplainGlobalFailure(ExplanationForSignedClause explanation, int F2, int E) {
        IntIterableRangeSet domain;
        IntIterableRangeSet dom_before;
        int max;
        int min;
        int i;
        assert (F2 < 0 ^ E < 0);
        for (i = 0; i < this.pos; ++i) {
            min = -1073741823;
            max = 0x3FFFFFFF;
            dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            if (F2 < 0) {
                max = dom_before.min() - 1;
            } else {
                min = dom_before.max() + 1;
            }
            domain = explanation.complement(((IntVar[])this.vars)[i]);
            domain.retainBetween(min, max);
            ((IntVar[])this.vars)[i].unionLit(domain, explanation);
        }
        while (i < this.l) {
            min = -1073741823;
            max = 0x3FFFFFFF;
            dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            if (F2 < 0) {
                min = dom_before.max() + 1;
            } else {
                max = dom_before.min() - 1;
            }
            domain = explanation.complement(((IntVar[])this.vars)[i]);
            domain.retainBetween(min, max);
            ((IntVar[])this.vars)[i].unionLit(domain, explanation);
            ++i;
        }
        if (this.model.getSettings().explainGlobalFailureInSum() && !this.isReified()) {
            this.explainGlobal(explanation, F2, E);
        }
    }

    protected void explainGlobal(ExplanationForSignedClause explanation, int F2, int E) {
        assert (F2 < 0 ^ E < 0);
        ClauseBuilder ngb = this.model.getClauseBuilder();
        for (int i = 0; i < this.l; ++i) {
            int min = -1073741823;
            int max = 0x3FFFFFFF;
            IntIterableRangeSet dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            if (F2 < 0) {
                if (i < this.pos) {
                    max = F2 + dom_before.min();
                } else {
                    min = -(F2 - dom_before.max());
                }
            } else if (i < this.pos) {
                min = -E + dom_before.max();
            } else {
                max = -(-E - dom_before.min());
            }
            IntIterableRangeSet domain = explanation.root(((IntVar[])this.vars)[i]);
            domain.retainBetween(min, max);
            ngb.put(((IntVar[])this.vars)[i], domain);
            for (int k = 0; k < this.l; ++k) {
                if (k == i) continue;
                min = -1073741823;
                max = 0x3FFFFFFF;
                dom_before = explanation.readDom(((IntVar[])this.vars)[k]);
                if (F2 < 0) {
                    if (k < this.pos) {
                        min = dom_before.min();
                    } else {
                        max = dom_before.max();
                    }
                } else if (k < this.pos) {
                    max = dom_before.max();
                } else {
                    min = dom_before.min();
                }
                domain = explanation.root(((IntVar[])this.vars)[k]);
                domain.removeBetween(min, max);
                ngb.put(((IntVar[])this.vars)[k], domain);
            }
            ngb.buildNogood(this.model);
            if (E != -1 && F2 != -1) continue;
            return;
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(this.pos == 0 ? "-" : "").append(((IntVar[])this.vars)[0].getName());
        for (i = 1; i < this.pos; ++i) {
            linComb.append(" + ").append(((IntVar[])this.vars)[i].getName());
        }
        while (i < this.l) {
            linComb.append(" - ").append(((IntVar[])this.vars)[i].getName());
            ++i;
        }
        linComb.append(" ").append((Object)this.o).append(" ");
        linComb.append(this.b);
        return linComb.toString();
    }

    public static int nb(Operator co) {
        switch (co) {
            case LE: {
                return 1;
            }
            case GE: {
                return -1;
            }
        }
        return 0;
    }

    public static Operator nop(Operator co) {
        switch (co) {
            case LE: {
                return Operator.GE;
            }
            case GE: {
                return Operator.LE;
            }
        }
        return Operator.getOpposite(co);
    }

    protected PropSum opposite() {
        return new PropSum((IntVar[])this.vars, this.pos, PropSum.nop(this.o), this.b + PropSum.nb(this.o));
    }
}

