/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import org.chocosolver.util.objects.IVal;

public class ArrayVal
implements IVal {
    private final double[] Av;
    private final double[] mAv;
    private final int size;
    private final int os;

    public ArrayVal(int size, int os) {
        this.size = size;
        this.os = os;
        this.Av = new double[size];
        this.mAv = new double[size];
    }

    @Override
    public double activity(int value) {
        return this.Av[value - this.os];
    }

    @Override
    public void setactivity(int value, double activity) {
        this.Av[value - this.os] = activity;
    }

    @Override
    public void update(int nb_probes) {
        int j = 0;
        while (j < this.Av.length) {
            double activity = this.Av[j];
            double oldmA = this.mAv[j];
            double U = activity - oldmA;
            int n = j++;
            this.mAv[n] = this.mAv[n] + U / (double)nb_probes;
        }
    }

    @Override
    public void transfer() {
        System.arraycopy(this.mAv, 0, this.Av, 0, this.size);
    }
}

