/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;

public class RegressionByDiscretization
extends SingleClassifierEnhancer {
    static final long serialVersionUID = 5066426153134050378L;
    protected Discretize m_Discretizer = new Discretize();
    protected int m_NumBins = 10;
    protected double[] m_ClassMeans;
    protected boolean m_DeleteEmptyBins;
    protected Instances m_DiscretizedHeader = null;
    protected boolean m_UseEqualFrequency = false;

    public String globalInfo() {
        return "A regression scheme that employs any classifier on a copy of the data that has the class attribute (equal-width) discretized. The predicted value is the expected value of the mean class value for each discretized interval (based on the predicted probabilities for each interval).";
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public RegressionByDiscretization() {
        this.m_Classifier = new J48();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.setMinimumNumberInstances(2);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Discretizer.setIgnoreClass(true);
        this.m_Discretizer.setAttributeIndices("" + (instances.classIndex() + 1));
        this.m_Discretizer.setBins(this.getNumBins());
        this.m_Discretizer.setUseEqualFrequency(this.getUseEqualFrequency());
        this.m_Discretizer.setInputFormat(instances);
        Instances newTrain = Filter.useFilter(instances, this.m_Discretizer);
        if (this.m_DeleteEmptyBins) {
            int numNonEmptyClasses = 0;
            boolean[] notEmptyClass = new boolean[newTrain.numClasses()];
            int i = 0;
            while (i < newTrain.numInstances()) {
                if (!notEmptyClass[(int)newTrain.instance(i).classValue()]) {
                    ++numNonEmptyClasses;
                    notEmptyClass[(int)newTrain.instance((int)i).classValue()] = true;
                }
                ++i;
            }
            FastVector newClassVals = new FastVector(numNonEmptyClasses);
            int[] oldIndexToNewIndex = new int[newTrain.numClasses()];
            int i2 = 0;
            while (i2 < newTrain.numClasses()) {
                if (notEmptyClass[i2]) {
                    oldIndexToNewIndex[i2] = newClassVals.size();
                    newClassVals.addElement(newTrain.classAttribute().value(i2));
                }
                ++i2;
            }
            Attribute newClass = new Attribute(newTrain.classAttribute().name(), newClassVals);
            FastVector newAttributes = new FastVector(newTrain.numAttributes());
            int i3 = 0;
            while (i3 < newTrain.numAttributes()) {
                if (i3 != newTrain.classIndex()) {
                    newAttributes.addElement(newTrain.attribute(i3).copy());
                } else {
                    newAttributes.addElement(newClass);
                }
                ++i3;
            }
            Instances newTrainTransformed = new Instances(newTrain.relationName(), newAttributes, newTrain.numInstances());
            newTrainTransformed.setClassIndex(newTrain.classIndex());
            int i4 = 0;
            while (i4 < newTrain.numInstances()) {
                Instance inst = newTrain.instance(i4);
                newTrainTransformed.add(inst);
                newTrainTransformed.lastInstance().setClassValue(oldIndexToNewIndex[(int)inst.classValue()]);
                ++i4;
            }
            newTrain = newTrainTransformed;
        }
        this.m_DiscretizedHeader = new Instances(newTrain, 0);
        int numClasses = newTrain.numClasses();
        this.m_ClassMeans = new double[numClasses];
        int[] classCounts = new int[numClasses];
        int i = 0;
        while (i < instances.numInstances()) {
            Instance inst = newTrain.instance(i);
            if (!inst.classIsMissing()) {
                int classVal;
                int n = classVal = (int)inst.classValue();
                classCounts[n] = classCounts[n] + 1;
                int n2 = classVal;
                this.m_ClassMeans[n2] = this.m_ClassMeans[n2] + instances.instance(i).classValue();
            }
            ++i;
        }
        i = 0;
        while (i < numClasses) {
            if (classCounts[i] > 0) {
                int n = i;
                this.m_ClassMeans[n] = this.m_ClassMeans[n] / (double)classCounts[i];
            }
            ++i;
        }
        if (this.m_Debug) {
            System.out.println("Bin Means");
            System.out.println("==========");
            i = 0;
            while (i < this.m_ClassMeans.length) {
                System.out.println(this.m_ClassMeans[i]);
                ++i;
            }
            System.out.println();
        }
        this.m_Classifier.buildClassifier(newTrain);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        Instance newInstance = (Instance)instance.copy();
        newInstance.setDataset(this.m_DiscretizedHeader);
        double[] probs = this.m_Classifier.distributionForInstance(newInstance);
        double prediction = 0.0;
        double probSum = 0.0;
        int j = 0;
        while (j < probs.length) {
            prediction += probs[j] * this.m_ClassMeans[j];
            probSum += probs[j];
            ++j;
        }
        return prediction / probSum;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tNumber of bins for equal-width discretization\n\t(default 10).\n", "B", 1, "-B <int>"));
        newVector.addElement(new Option("\tWhether to delete empty bins after discretization\n\t(default false).\n", "E", 0, "-E"));
        newVector.addElement(new Option("\tUse equal-frequency instead of equal-width discretization.", "F", 0, "-F"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String binsString = Utils.getOption('B', options);
        if (binsString.length() != 0) {
            this.setNumBins(Integer.parseInt(binsString));
        } else {
            this.setNumBins(10);
        }
        this.setDeleteEmptyBins(Utils.getFlag('E', options));
        this.setUseEqualFrequency(Utils.getFlag('F', options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 4];
        int current = 0;
        options[current++] = "-B";
        options[current++] = "" + this.getNumBins();
        if (this.getDeleteEmptyBins()) {
            options[current++] = "-E";
        }
        if (this.getUseEqualFrequency()) {
            options[current++] = "-F";
        }
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        current += superOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String numBinsTipText() {
        return "Number of bins for discretization.";
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public void setNumBins(int numBins) {
        this.m_NumBins = numBins;
    }

    public String deleteEmptyBinsTipText() {
        return "Whether to delete empty bins after discretization.";
    }

    public boolean getDeleteEmptyBins() {
        return this.m_DeleteEmptyBins;
    }

    public void setDeleteEmptyBins(boolean b) {
        this.m_DeleteEmptyBins = b;
    }

    public String useEqualFrequencyTipText() {
        return "If set to true, equal-frequency binning will be used instead of equal-width binning.";
    }

    public boolean getUseEqualFrequency() {
        return this.m_UseEqualFrequency;
    }

    public void setUseEqualFrequency(boolean newUseEqualFrequency) {
        this.m_UseEqualFrequency = newUseEqualFrequency;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("Regression by discretization");
        if (this.m_ClassMeans == null) {
            text.append(": No model built yet.");
        } else {
            text.append("\n\nClass attribute discretized into " + this.m_ClassMeans.length + " values\n");
            text.append("\nClassifier spec: " + this.getClassifierSpec() + "\n");
            text.append(this.m_Classifier.toString());
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4746 $");
    }

    public static void main(String[] argv) {
        RegressionByDiscretization.runClassifier(new RegressionByDiscretization(), argv);
    }
}

