#' seek the nearest codes/units from an som object
#' 
#' @param  out.som an object generated by som() 
#' @return indices of pair nearest codes (a matrix of n*2 containing indices of pair nearest codes)
#' @keywords nearest.codes.som
#' @export 
#' @import kohonen
#' @author Ai-bing ZHANG,PhD. CNU, Beijing, CHINA, contact at zhangab2008(at)mail.cnu.edu.cn
#' @references Zhang et al. 2015.Initinally created on 2014/8/13 15:59:35
#' @examples
#' require(kohonen)
#' data(wines)
#' set.seed(7)
#' training <- sample(nrow(wines), 120)
#' Xtraining <- scale(wines[training, ])
#' out.som <- som(Xtraining, grid = somgrid(5, 5, "hexagonal"))
#' nn.codes<-nearest.codes.som(out.som)
#' nn.codes


library(testthat)
context("nearest.codes.som: seek the nearest codes/units from an som object")
test_that("nearest.codes.som: seek the nearest codes/units from an som object",{
  require(kohonen)
  data(wines)
  set.seed(7)
  training <- sample(nrow(wines), 120)
  Xtraining <- scale(wines[training, ])
  out.som <- som(Xtraining, grid = somgrid(5, 5, "hexagonal"))
  nn.codes<-nearest.codes.som(out.som)
  nn.codes

  expect_that(length(nn.codes),
              equals(2)) 
  
})
