/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering;

import dr.evolution.datatype.Nucleotides;
import dr.evolution.tree.NodeRef;
import dr.evomodel.antigenic.phyloclustering.misc.obsolete.TiterImporter;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class TreeClusteringVirusesPrior
extends AbstractModelLikelihood {
    public static final String TREE_CLUSTER_VIRUSES = "treeClusterViruses";
    private Parameter muPrecision;
    private Parameter p_on;
    private double initialK;
    private int startBase;
    private int endBase;
    private int numSites;
    private Parameter indicators;
    private Parameter probSites;
    private MatrixParameter mu;
    private Parameter clusterLabels;
    private Parameter clusterLabelsTreeNode;
    private MatrixParameter virusLocations = null;
    private MatrixParameter virusLocationsTreeNode = null;
    private Parameter muMean = null;
    boolean hasDrift;
    TreeModel treeModel;
    int numdata;
    int[] membershipToClusterLabelIndexes = null;
    private double mostRecentTransformedValue = 0.0;
    private boolean treeChanged = false;
    private String[] mutationString;
    private LinkedList<Integer>[] mutationList;
    private LinkedList<Integer>[] causalList;
    private int[] causalCount;
    private int[] nonCausalCount;
    private Parameter siteIndicators;
    private String gp_prior;
    private double prob00 = 0.95;
    private double prob11 = 0.5;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String EXCISIONPOINTS = "excisionPoints";
        public static final String CLUSTERLABELS = "clusterLabels";
        public static final String CLUSTERLABELSTREENODE = "clusterLabelsTreeNode";
        public static final String MU = "mu";
        public static final String OFFSETS = "offsets";
        public static final String VIRUS_LOCATIONS = "virusLocations";
        public static final String VIRUS_LOCATIONSTREENODE = "virusLocationsTreeNodes";
        public static final String INDICATORS = "indicators";
        public static final String PROBSITES = "probSites";
        public static final String SITEINDICATORS = "siteIndicators";
        boolean integrate = false;
        public static final String MUPRECISION = "muPrecision";
        public static final String PROBACTIVENODE = "probActiveNode";
        public static final String INITIALNUMCLUSTERS = "initialK";
        public static final String MUMEAN = "muMean";
        public static final String STARTBASE = "startNucleotide";
        public static final String ENDBASE = "endNucleotide";
        public static final String PROB00 = "prob00";
        public static final String PROB11 = "prob11";
        public static final String INITIAL_PROBSITE_VALUE = "initialProbSite";
        public static final String GP_PRIOR_OPTION = "gp_prior";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("initialK", true, "the initial number of clusters"), AttributeRule.newDoubleRule("startNucleotide", true, "the start base in the sequence to consider in the genotype to phenotype model"), AttributeRule.newIntegerRule("endNucleotide", true, "the end base in the sequence to consider in the genotype to phenotype model"), AttributeRule.newIntegerRule("startNucleotide", true, "the start base in the sequence to consider in the genotype to phenotype model"), AttributeRule.newDoubleRule("prob00", true, "correlated prior - the probability of staying at state 0 for adjacent siteIndicator"), AttributeRule.newDoubleRule("prob11", true, "correlated prior - the probability of staying at state 1 for adjacent siteIndicator"), AttributeRule.newStringRule("gp_prior", true, "specifying the prior for probSites (and siteIndicators)"), AttributeRule.newDoubleRule("initialProbSite", true, "the initial value of the probSite"), new ElementRule("excisionPoints", Parameter.class), new ElementRule("clusterLabels", Parameter.class), new ElementRule("clusterLabelsTreeNode", Parameter.class), new ElementRule("virusLocationsTreeNodes", MatrixParameter.class), new ElementRule("mu", MatrixParameter.class), new ElementRule("virusLocations", MatrixParameter.class), new ElementRule("indicators", Parameter.class), new ElementRule("siteIndicators", Parameter.class, "the indicator of a site having probability greater than 0 of being associated with antigenic transition", true), new ElementRule("probSites", Parameter.class, "the probability that mutation on a site is associated with antigenic transition", true), new ElementRule(TreeModel.class), new ElementRule("muPrecision", Parameter.class), new ElementRule("probActiveNode", Parameter.class), new ElementRule("muMean", Parameter.class)};

        @Override
        public String getParserName() {
            return TreeClusteringVirusesPrior.TREE_CLUSTER_VIRUSES;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = 10.0;
            if (xMLObject.hasAttribute(INITIALNUMCLUSTERS)) {
                d = xMLObject.getDoubleAttribute(INITIALNUMCLUSTERS);
            }
            double d2 = 0.95;
            if (xMLObject.hasAttribute(PROB00)) {
                d2 = xMLObject.getDoubleAttribute(PROB00);
            }
            double d3 = 0.5;
            if (xMLObject.hasAttribute(PROB11)) {
                d3 = xMLObject.getDoubleAttribute(PROB11);
            }
            double d4 = 0.05;
            if (xMLObject.hasAttribute(INITIAL_PROBSITE_VALUE)) {
                d4 = xMLObject.getDoubleAttribute(INITIAL_PROBSITE_VALUE);
            }
            int n = 0;
            if (xMLObject.hasAttribute(STARTBASE)) {
                n = xMLObject.getIntegerAttribute(STARTBASE) - 1;
            }
            int n2 = -1;
            if (xMLObject.hasAttribute(ENDBASE)) {
                n2 = xMLObject.getIntegerAttribute(ENDBASE) - 1;
            }
            String string = "";
            if (xMLObject.hasAttribute(GP_PRIOR_OPTION)) {
                string = xMLObject.getStringAttribute(GP_PRIOR_OPTION);
            }
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            XMLObject xMLObject2 = xMLObject.getChild(CLUSTERLABELS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(CLUSTERLABELSTREENODE);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(VIRUS_LOCATIONS);
            MatrixParameter matrixParameter2 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(VIRUS_LOCATIONSTREENODE);
            MatrixParameter matrixParameter3 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(SITEINDICATORS);
            Parameter parameter4 = null;
            if (xMLObject2 != null) {
                parameter4 = (Parameter)xMLObject2.getChild(Parameter.class);
            }
            xMLObject2 = xMLObject.getChild(PROBSITES);
            Parameter parameter5 = null;
            if (xMLObject2 != null) {
                parameter5 = (Parameter)xMLObject2.getChild(Parameter.class);
            }
            xMLObject2 = xMLObject.getChild(MUPRECISION);
            Parameter parameter6 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(PROBACTIVENODE);
            Parameter parameter7 = (Parameter)xMLObject2.getChild(Parameter.class);
            boolean bl = false;
            xMLObject2 = xMLObject.getChild(MUMEAN);
            Parameter parameter8 = (Parameter)xMLObject2.getChild(Parameter.class);
            return new TreeClusteringVirusesPrior(treeModel, parameter3, parameter, parameter2, matrixParameter, bl, matrixParameter2, matrixParameter3, parameter6, parameter7, d, parameter8, parameter5, parameter4, n, n2, string, d2, d3, d4);
        }

        @Override
        public String getParserDescription() {
            return "tree clustering viruses";
        }

        @Override
        public Class getReturnType() {
            return TreeClusteringVirusesPrior.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    String Atribute = null;

    public LinkedList<Integer>[] getMutationList() {
        return this.mutationList;
    }

    public LinkedList<Integer>[] getCausalList() {
        return this.causalList;
    }

    public TreeClusteringVirusesPrior(TreeModel treeModel, Parameter parameter, Parameter parameter2, Parameter parameter3, MatrixParameter matrixParameter, Boolean bl, MatrixParameter matrixParameter2, MatrixParameter matrixParameter3, Parameter parameter4, Parameter parameter5, double d, Parameter parameter6, Parameter parameter7, Parameter parameter8, int n, int n2, String string, double d2, double d3, double d4) {
        super(TREE_CLUSTER_VIRUSES);
        int n3;
        System.out.println("loading the constructor for TreeClusterViruses");
        if (parameter7 == null) {
            System.out.println("Antigenic Clustering only");
        } else {
            System.out.println("Antigenic Genotype to Phenotype model");
        }
        this.treeModel = treeModel;
        if (parameter7 != null) {
            this.startBase = n;
            this.endBase = n2;
            this.gp_prior = string;
            System.out.println("gp prior = " + this.gp_prior);
            if (this.gp_prior.compareTo("generic") != 0 && this.gp_prior.compareTo("saturated") != 0 && this.gp_prior.compareTo("shrinkage") != 0 && this.gp_prior.compareTo("correlated") != 0) {
                System.out.println("Prior is incorrectly specified - choose from [generic/saturated/shrinkage/correlated]");
                System.exit(0);
            }
            this.treeMutations();
            this.probSites = parameter7;
            this.siteIndicators = parameter8;
            this.prob00 = d2;
            this.prob11 = d3;
        }
        this.indicators = parameter;
        this.clusterLabels = parameter2;
        this.clusterLabelsTreeNode = parameter3;
        this.mu = matrixParameter;
        this.hasDrift = bl;
        this.virusLocations = matrixParameter2;
        this.virusLocationsTreeNode = matrixParameter3;
        this.muPrecision = parameter4;
        this.p_on = parameter5;
        this.initialK = d;
        this.muMean = parameter6;
        System.out.println("sigmaSq = " + 1.0 / parameter4.getParameterValue(0));
        System.out.println("p_on = " + parameter5.getParameterValue(0));
        int n4 = this.treeModel.getNodeCount();
        this.numdata = matrixParameter2.getColumnDimension();
        this.clusterLabels.setDimension(this.numdata);
        for (n3 = 0; n3 < this.numdata; ++n3) {
            this.clusterLabels.setParameterValue(n3, 0.0);
        }
        this.addVariable(this.clusterLabels);
        this.indicators.setDimension(this.treeModel.getNodeCount());
        for (n3 = 0; n3 < this.treeModel.getNodeCount(); ++n3) {
            this.indicators.setParameterValue(n3, 0.0);
        }
        this.indicators.setParameterValue(this.treeModel.getRoot().getNumber(), 1.0);
        n3 = 0;
        while ((double)n3 < this.initialK - 1.0) {
            boolean bl2 = true;
            while (bl2) {
                int n5 = (int)Math.floor(Math.random() * (double)n4);
                if ((int)this.indicators.getParameterValue(n5) != 0) continue;
                if (parameter7 == null) {
                    this.indicators.setParameterValue(n5, 1.0);
                    bl2 = false;
                    continue;
                }
                if (this.mutationList[n5] == null) continue;
                this.indicators.setParameterValue(n5, 1.0);
                bl2 = false;
            }
            ++n3;
        }
        this.addVariable(this.indicators);
        if (parameter7 != null) {
            if (this.gp_prior.compareTo("generic") == 0) {
                this.probSites.setDimension(1);
                this.probSites.setParameterValue(0, d4);
            } else {
                this.probSites.setDimension(this.numSites);
                for (n3 = 0; n3 < this.numSites; ++n3) {
                    this.probSites.setParameterValue(n3, d4);
                }
            }
            this.addVariable(this.probSites);
            this.siteIndicators.setDimension(this.numSites);
            for (n3 = 0; n3 < this.numSites; ++n3) {
                this.siteIndicators.setParameterValue(n3, 1.0);
            }
            this.addVariable(this.siteIndicators);
        }
        this.clusterLabelsTreeNode.setDimension(this.treeModel.getNodeCount());
        this.addVariable(this.clusterLabelsTreeNode);
        this.mu.setColumnDimension(2);
        this.mu.setRowDimension(this.treeModel.getNodeCount());
        for (n3 = 0; n3 < this.treeModel.getNodeCount(); ++n3) {
            double d5 = 0.0;
            this.mu.getParameter(n3).setValue(0, d5);
            this.mu.getParameter(n3).setValue(1, d5);
        }
        this.addVariable(this.virusLocations);
        this.virusLocationsTreeNode.setColumnDimension(2);
        this.virusLocationsTreeNode.setRowDimension(n4);
        this.addVariable(this.virusLocationsTreeNode);
        this.addModel(this.treeModel);
        this.addVariable(this.mu);
        this.addVariable(parameter4);
        this.addVariable(this.p_on);
        this.numdata = this.virusLocations.getColumnDimension();
        if (parameter7 != null) {
            this.sampleCausativeStates();
        }
    }

    private void treeMutations() {
        int n;
        int n2;
        int n3;
        Object object;
        int n4 = this.treeModel.getNodeCount();
        String[] stringArray = new String[n4];
        String string = "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSS*CWCLFLF";
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            object = (String)this.treeModel.getNodeAttribute(this.treeModel.getNode(i), "states");
            if (this.endBase == -1) {
                this.endBase = ((String)object).length() - 1;
            }
            if ((this.endBase - this.startBase) % 3 != 0) {
                System.out.println("Nucleotide sequence needs to be triplet to convert to codon - check your startbase and endbase");
                System.exit(0);
            }
            if (this.endBase > ((String)object).length() - 1) {
                System.out.println("the last base cannot be greater than the length of the nucleotide. Exit now.");
                System.exit(0);
            }
            if (this.startBase > ((String)object).length() - 1) {
                System.out.println("the start base cannot be greater than the length of the nucleotide. Exit now.");
                System.exit(0);
            }
            if (this.startBase > this.endBase) {
                System.out.println("Start base cannot be greater than the end base");
                System.exit(0);
            }
            n5 = this.numSites = (this.endBase - this.startBase) / 3;
            object = ((String)object).substring(this.startBase, this.endBase);
            String string2 = "";
            for (n3 = 0; n3 < n5; ++n3) {
                int n6 = Nucleotides.NUCLEOTIDE_STATES[((String)object).charAt(n3 * 3)];
                n2 = Nucleotides.NUCLEOTIDE_STATES[((String)object).charAt(n3 * 3 + 1)];
                n = Nucleotides.NUCLEOTIDE_STATES[((String)object).charAt(n3 * 3 + 2)];
                int n7 = n6 * 16 + n2 * 4 + n;
                string2 = string2 + string.charAt(n7);
            }
            stringArray[i] = string2;
        }
        this.mutationList = new LinkedList[n4];
        this.mutationString = new String[this.treeModel.getNodeCount()];
        NodeRef nodeRef = this.treeModel.getRoot();
        object = new LinkedList();
        ((LinkedList)object).add(nodeRef);
        int n8 = 0;
        while (((LinkedList)object).size() > 0) {
            Object object2;
            ++n8;
            if (this.treeModel.getParent(nodeRef) != null) {
                this.mutationString[nodeRef.getNumber()] = "\"";
                String string3 = stringArray[nodeRef.getNumber()];
                object2 = stringArray[this.treeModel.getParent(nodeRef).getNumber()];
                n2 = 0;
                for (n = 0; n < n5; ++n) {
                    if (string3.charAt(n) == ((String)object2).charAt(n)) continue;
                    if (++n2 > 1) {
                        this.mutationString[nodeRef.getNumber()] = this.mutationString[nodeRef.getNumber()] + ",";
                    }
                    this.mutationString[nodeRef.getNumber()] = this.mutationString[nodeRef.getNumber()] + (n + 1);
                    if (this.mutationList[nodeRef.getNumber()] == null) {
                        this.mutationList[nodeRef.getNumber()] = new LinkedList();
                    }
                    this.mutationList[nodeRef.getNumber()].add(n + 1);
                }
                this.mutationString[nodeRef.getNumber()] = this.mutationString[nodeRef.getNumber()] + "\"";
            }
            for (n3 = 0; n3 < this.treeModel.getChildCount(nodeRef); ++n3) {
                object2 = this.treeModel.getChild(nodeRef, n3);
                ((LinkedList)object).add(object2);
            }
            ((LinkedList)object).pop();
            if (((LinkedList)object).size() <= 0) continue;
            nodeRef = (NodeRef)((LinkedList)object).getFirst();
        }
    }

    @Override
    public double getLogLikelihood() {
        double d = this.treeModel.getNodeCount();
        int n = 0;
        for (int i = 0; i < this.indicators.getDimension(); ++i) {
            n += (int)this.indicators.getParameterValue(i);
        }
        double d2 = 0.0;
        double d3 = 1.0 / this.muPrecision.getParameterValue(0);
        double d4 = this.p_on.getParameterValue(0);
        double d5 = this.muMean.getParameterValue(0);
        int n2 = 0;
        while ((double)n2 < d) {
            double d6 = this.mu.getParameter(n2).getParameterValue(0);
            double d7 = this.mu.getParameter(n2).getParameterValue(1);
            d2 -= 0.5 * ((d6 - d5) * (d6 - d5) + d7 * d7) / d3;
            ++n2;
        }
        if (this.probSites == null) {
            d2 -= (double)n * (Math.log(2.0) + Math.log(Math.PI) + Math.log(d3));
        } else {
            d2 -= d * (Math.log(2.0) + Math.log(Math.PI) + Math.log(d3));
            double d8 = 0.0;
            if (this.gp_prior.compareTo("correlated") == 0) {
                d8 = this.correlatedPriorComputation();
            } else if (this.gp_prior.compareTo("shrinkage") == 0) {
                d8 = this.shrinkagePriorComputation();
            } else if (this.gp_prior.compareTo("generic") == 0) {
                d8 = this.genericPriorComputation();
            } else if (this.gp_prior.compareTo("saturated") == 0) {
                d8 = this.saturatedPriorComputation();
            } else {
                System.out.println("Prior unknown. quit now");
                System.exit(0);
            }
            if ((d2 += d8) != Double.NEGATIVE_INFINITY) {
                this.sampleCausativeStates();
            }
        }
        return d2;
    }

    private double saturatedPriorComputation() {
        int n;
        double d = 0.0;
        double d2 = this.treeModel.getNodeCount();
        double[] dArray = new double[this.numSites];
        for (n = 0; n < this.numSites; ++n) {
            dArray[n] = this.probSites.getParameterValue(n);
        }
        n = 0;
        while ((double)n < d2 - 1.0) {
            double d3 = 1.0;
            double d4 = 1.0;
            if (this.mutationList[n] != null) {
                Iterator iterator = this.mutationList[n].iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    d4 *= 1.0 - dArray[n2 - 1];
                }
            }
            d3 = 1.0 - d4;
            d = (int)this.indicators.getParameterValue(n) == 1 ? (d += Math.log(d3)) : (d += Math.log(1.0 - d3));
            ++n;
        }
        return d;
    }

    private double genericPriorComputation() {
        double d = 0.0;
        double d2 = this.treeModel.getNodeCount();
        double d3 = this.probSites.getParameterValue(0);
        int n = 0;
        while ((double)n < d2 - 1.0) {
            double d4 = 1.0;
            double d5 = 1.0;
            if (this.mutationList[n] != null) {
                Iterator iterator = this.mutationList[n].iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    d5 *= 1.0 - d3;
                }
            }
            d4 = 1.0 - d5;
            d = (int)this.indicators.getParameterValue(n) == 1 ? (d += Math.log(d4)) : (d += Math.log(1.0 - d4));
            ++n;
        }
        return d;
    }

    private double shrinkagePriorComputation() {
        int n;
        int n2;
        double d = 0.0;
        double d2 = this.treeModel.getNodeCount();
        double[] dArray = new double[this.numSites];
        for (n2 = 0; n2 < this.numSites; ++n2) {
            dArray[n2] = this.probSites.getParameterValue(n2) * this.siteIndicators.getParameterValue(n2);
        }
        n2 = 0;
        while ((double)n2 < d2 - 1.0) {
            double d3 = 1.0;
            double d4 = 1.0;
            if (this.mutationList[n2] != null) {
                Iterator iterator = this.mutationList[n2].iterator();
                while (iterator.hasNext()) {
                    int n3 = (Integer)iterator.next();
                    d4 *= 1.0 - dArray[n3 - 1];
                }
            }
            d3 = 1.0 - d4;
            d = (int)this.indicators.getParameterValue(n2) == 1 ? (d += Math.log(d3)) : (d += Math.log(1.0 - d3));
            ++n2;
        }
        n2 = 0;
        for (n = 0; n < this.numSites; ++n) {
            if ((int)this.siteIndicators.getParameterValue(n) != 1) continue;
            ++n2;
        }
        n = this.numSites - n2;
        return d += (double)n2 * Math.log(this.p_on.getParameterValue(0)) + (double)n * Math.log(1.0 - this.p_on.getParameterValue(0));
    }

    private double correlatedPriorComputation() {
        int n;
        double d = 0.0;
        double d2 = this.treeModel.getNodeCount();
        double[] dArray = new double[this.numSites];
        for (n = 0; n < this.numSites; ++n) {
            dArray[n] = this.probSites.getParameterValue(n) * this.siteIndicators.getParameterValue(n);
        }
        n = 0;
        while ((double)n < d2 - 1.0) {
            double d3 = 1.0;
            double d4 = 1.0;
            if (this.mutationList[n] != null) {
                Iterator iterator = this.mutationList[n].iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    d4 *= 1.0 - dArray[n2 - 1];
                }
            }
            d3 = 1.0 - d4;
            d = (int)this.indicators.getParameterValue(n) == 1 ? (d += Math.log(d3)) : (d += Math.log(1.0 - d3));
            ++n;
        }
        d += Math.log(0.5);
        n = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 1; i < this.numSites; ++i) {
            if ((int)this.siteIndicators.getParameterValue(i - 1) == 0) {
                if ((int)this.siteIndicators.getParameterValue(i) == 0) {
                    ++n3;
                    continue;
                }
                ++n4;
                continue;
            }
            if ((int)this.siteIndicators.getParameterValue(i) == 0) {
                ++n5;
                continue;
            }
            ++n6;
        }
        double d5 = this.prob00;
        double d6 = this.prob11;
        return d += (double)n3 * Math.log(d5) + (double)n4 * Math.log(1.0 - d5) + (double)n5 * Math.log(1.0 - d6) + (double)n6 * Math.log(d6);
    }

    public int[] getCausalCount() {
        return this.causalCount;
    }

    public int[] getNonCausalCount() {
        return this.nonCausalCount;
    }

    public LinkedList<Integer>[] getMutationsPerNode() {
        return this.mutationList;
    }

    public LinkedList<Integer>[] getCausativeStatesPerNode() {
        return this.causalList;
    }

    public void sampleCausativeStates() {
        int n;
        this.causalCount = new int[this.numSites];
        this.nonCausalCount = new int[this.numSites];
        for (n = 0; n < this.numSites; ++n) {
            this.causalCount[n] = 0;
            this.nonCausalCount[n] = 0;
        }
        n = this.treeModel.getNodeCount();
        this.causalList = new LinkedList[n];
        for (int i = 0; i < n - 1; ++i) {
            double d = 1.0;
            double d2 = 1.0;
            if ((int)this.indicators.getParameterValue(i) == 0) {
                if (this.mutationList[i] == null) continue;
                this.causalList[i] = new LinkedList();
                Iterator iterator = this.mutationList[i].iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    this.causalList[i].add(new Integer(0));
                    int n3 = n2 - 1;
                    this.nonCausalCount[n3] = this.nonCausalCount[n3] + 1;
                }
                continue;
            }
            if (this.mutationList[i] == null) continue;
            int n4 = this.mutationList[i].size();
            this.causalList[i] = new LinkedList();
            double[] dArray = new double[n4];
            Iterator iterator = this.mutationList[i].iterator();
            int n5 = 0;
            while (iterator.hasNext()) {
                int n6 = (Integer)iterator.next();
                if (this.gp_prior.compareTo("generic") == 0) {
                    dArray[n5] = this.probSites.getParameterValue(0);
                } else if (this.gp_prior.compareTo("saturated") == 0) {
                    dArray[n5] = this.probSites.getParameterValue(n6 - 1);
                } else if (this.gp_prior.compareTo("correlated") == 0 || this.gp_prior.compareTo("shrinkage") == 0) {
                    dArray[n5] = this.probSites.getParameterValue(n6 - 1) * this.siteIndicators.getParameterValue(n6 - 1);
                }
                ++n5;
            }
            double[] dArray2 = new double[(int)Math.pow(2.0, n4)];
            int n7 = 0;
            while ((double)n7 < Math.pow(2.0, n4)) {
                int n8;
                int n9 = n7;
                int[] nArray = new int[n4];
                for (n8 = n4 - 1; n8 >= 0; --n8) {
                    nArray[n8] = (n9 & 1 << n8) != 0 ? 1 : 0;
                }
                dArray2[n7] = 1.0;
                for (n8 = 0; n8 < n4; ++n8) {
                    dArray2[n7] = nArray[n8] == 1 ? dArray2[n7] * dArray[n8] : dArray2[n7] * (1.0 - dArray[n8]);
                }
                ++n7;
            }
            dArray2[0] = 0.0;
            n7 = MathUtils.randomChoicePDF(dArray2);
            int[] nArray = new int[n4];
            for (int j = n4 - 1; j >= 0; --j) {
                nArray[j] = (n7 & 1 << j) != 0 ? 1 : 0;
                this.causalList[i].add(new Integer(nArray[j]));
                if (nArray[j] == 1) {
                    int n10 = this.mutationList[i].get(j) - 1;
                    this.causalCount[n10] = this.causalCount[n10] + 1;
                    continue;
                }
                int n11 = this.mutationList[i].get(j) - 1;
                this.nonCausalCount[n11] = this.nonCausalCount[n11] + 1;
            }
        }
    }

    private void loadIndicators() {
        try {
            String string;
            FileReader fileReader = new FileReader("/Users/charles/Documents/researchData/clustering/output/test26/run20-test/H3N2_mds.indicatorsStat-120000.log");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string;
            }
            String[] stringArray = string2.split("\t");
            for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
                this.indicators.setParameterValue(i, Double.parseDouble(stringArray[i + 1]));
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void loadInitialMuLocations() {
        try {
            String string;
            FileReader fileReader = new FileReader("/Users/charles/Documents/researchData/clustering/output/test25/run79/H3N2_mds.mu.log");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string;
            }
            String[] stringArray = string2.split("\t");
            for (int i = 0; i < this.mu.getParameterCount(); ++i) {
                double d = Double.parseDouble(stringArray[i * 2 + 1]);
                double d2 = Double.parseDouble(stringArray[i * 2 + 2]);
                this.mu.getParameter(i).setParameterValue(0, d);
                this.mu.getParameter(i).setParameterValue(1, d2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setMembershipToClusterLabelIndexes() {
        int n = this.treeModel.getNodeCount();
        this.membershipToClusterLabelIndexes = new int[this.numdata];
        for (int i = 0; i < this.numdata; ++i) {
            Parameter parameter = this.virusLocations.getParameter(i);
            String string = parameter.getParameterName();
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                String string2 = this.treeModel.getTaxonId(j);
                if (!string.equals(string2)) continue;
                this.membershipToClusterLabelIndexes[i] = j;
                bl = true;
                break;
            }
            if (bl) continue;
            System.out.println("not found. Exit now.");
            System.exit(0);
        }
    }

    private void setClusterLabelsParameter() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.treeModel.getNodeCount(); ++n) {
            if ((int)this.indicators.getParameterValue(n) != 1) continue;
            ++n2;
        }
        n = this.treeModel.getNodeCount();
        int[] nArray = new int[n2];
        int n3 = 0;
        String string = "";
        for (int i = 0; i < n; ++i) {
            if ((int)this.indicators.getParameterValue(i) != 1) continue;
            nArray[n3] = i;
            string = string + i + ",";
            ++n3;
        }
        int[] nArray2 = TreeClusteringVirusesPrior.determine_membership(this.treeModel, nArray, n2);
        for (int i = 0; i < this.numdata; ++i) {
            this.clusterLabels.setParameterValue(i, nArray2[this.membershipToClusterLabelIndexes[i]]);
        }
    }

    static int[] determine_membership(TreeModel treeModel, int[] nArray, int n) {
        TiterImporter titerImporter = null;
        try {
            FileReader fileReader = new FileReader("/Users/charles/Documents/research/antigenic/GenoPheno/data/taxon_y_titer.txt");
            titerImporter = new TiterImporter(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        NodeRef nodeRef = treeModel.getRoot();
        int n2 = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray2 = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray2[i] = -1;
        }
        nArray2[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                nArray2[nodeRef2.getNumber()] = TreeClusteringVirusesPrior.isCutNode(nodeRef2.getNumber(), nArray, n) ? ++n2 - 1 : nArray2[treeModel.getParent(nodeRef2).getNumber()];
            }
            string = string + " cluster = " + nArray2[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray2;
    }

    private static boolean isCutNode(int n, int[] nArray, int n2) {
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    public int factorial(int n) {
        int n2 = 1;
        for (int i = 1; i <= n; ++i) {
            n2 *= i;
        }
        return n2;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public void acceptState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void storeState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            this.treeChanged = true;
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    public int getNumSites() {
        return this.numSites;
    }

    public int getStartBase() {
        return this.startBase;
    }

    public int getEndBase() {
        return this.endBase;
    }
}

