/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.operators;

import dr.evomodel.antigenic.phyloclustering.operators.TreeClusterAlgorithmOperator;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class randomWalkSerumDriftAndMu
extends SimpleMCMCOperator {
    public static final String SERUMDRIFT_AND_MU_OPERATOR = "serumDriftAndMuOperator";
    Parameter indicators;
    MatrixParameter mu;
    Parameter serumDrift;
    private TreeModel treeModel;
    private double maxWalkSize;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String MU = "mu";
        public static final String SERUMDRIFT = "serumDrift";
        public static final String INDICATORS = "indicators";
        public static final String WALKSIZE = "walkSize";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("walkSize"), new ElementRule("mu", Parameter.class), new ElementRule("serumDrift", Parameter.class), new ElementRule("indicators", Parameter.class), new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return randomWalkSerumDriftAndMu.SERUMDRIFT_AND_MU_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = 0.05;
            if (xMLObject.hasAttribute(WALKSIZE)) {
                d2 = xMLObject.getDoubleAttribute(WALKSIZE);
            }
            XMLObject xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(SERUMDRIFT);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            return new randomWalkSerumDriftAndMu(matrixParameter, d, parameter2, parameter, d2, treeModel);
        }

        @Override
        public String getParserDescription() {
            return "An operator that picks a new allocation of an item to a cluster under the Dirichlet process.";
        }

        @Override
        public Class getReturnType() {
            return TreeClusterAlgorithmOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public randomWalkSerumDriftAndMu(MatrixParameter matrixParameter, double d, Parameter parameter, Parameter parameter2, double d2, TreeModel treeModel) {
        this.mu = matrixParameter;
        this.indicators = parameter;
        this.serumDrift = parameter2;
        this.maxWalkSize = d2;
        this.treeModel = treeModel;
        this.setWeight(d);
        System.out.println("Finished loading the constructor for SERUMDRIFT_AND_MU_OPERATOR");
    }

    @Override
    public final double doOperation() {
        double d = 0.0;
        int n = this.treeModel.getRoot().getNumber();
        double d2 = MathUtils.nextDouble() * this.maxWalkSize - this.maxWalkSize / 2.0;
        double d3 = this.serumDrift.getParameterValue(0);
        double d4 = d3 + d2;
        this.serumDrift.setParameterValue(0, d4);
        for (int i = 0; i < this.mu.getParameterCount(); ++i) {
            if ((int)this.indicators.getParameterValue(i) != 1 || i == n) continue;
            Parameter parameter = this.mu.getParameter(i);
            double d5 = parameter.getParameterValue(0);
            double d6 = d5 * d4 / d3;
            parameter.setParameterValue(0, d6);
        }
        return d;
    }

    @Override
    public void accept(double d) {
        super.accept(d);
    }

    @Override
    public void reject() {
        super.reject();
    }

    @Override
    public final String getOperatorName() {
        return SERUMDRIFT_AND_MU_OPERATOR;
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }
}

