/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.evomodel.antigenic.phyloclustering.TreeClusteringVirusesPrior;
import dr.evomodel.tree.TreeModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Iterator;
import java.util.LinkedList;

public class CausalMutationsLogger
implements Loggable {
    public static final String PARSER_NAME = "causalMutationsLogger";
    private TreeModel treeModel;
    private TreeClusteringVirusesPrior clusterPrior;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), new ElementRule(TreeClusteringVirusesPrior.class)};

        @Override
        public String getParserName() {
            return CausalMutationsLogger.PARSER_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            TreeClusteringVirusesPrior treeClusteringVirusesPrior = (TreeClusteringVirusesPrior)xMLObject.getChild(TreeClusteringVirusesPrior.class);
            return new CausalMutationsLogger(treeModel, treeClusteringVirusesPrior);
        }

        @Override
        public String getParserDescription() {
            return ".";
        }

        @Override
        public Class getReturnType() {
            return CausalMutationsLogger.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    @Override
    public LogColumn[] getColumns() {
        int n = this.treeModel.getNodeCount();
        LogColumn[] logColumnArray = new LogColumn[n];
        for (int i = 0; i < n; ++i) {
            String string = "" + i + ":";
            LinkedList<Integer>[] linkedListArray = this.clusterPrior.getMutationList();
            if (linkedListArray[i] != null) {
                Iterator iterator = linkedListArray[i].iterator();
                int n2 = 0;
                while (iterator.hasNext()) {
                    if (n2 > 0) {
                        string = string + ",";
                    }
                    int n3 = (Integer)iterator.next();
                    string = string + n3;
                    ++n2;
                }
            }
            final int n4 = i;
            logColumnArray[i] = new LogColumn.Abstract(string){

                @Override
                protected String getFormattedValue() {
                    LinkedList<Integer>[] linkedListArray = CausalMutationsLogger.this.clusterPrior.getCausalList();
                    return CausalMutationsLogger.this.parseCausalList(linkedListArray[n4]);
                }
            };
        }
        return logColumnArray;
    }

    public String parseCausalList(LinkedList<Integer> linkedList) {
        String string = "";
        if (linkedList != null) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                string = string + n;
            }
            string = "s" + new StringBuilder(string).reverse().toString();
        } else {
            string = "s";
        }
        return string;
    }

    public CausalMutationsLogger(TreeModel treeModel, TreeClusteringVirusesPrior treeClusteringVirusesPrior) {
        this.treeModel = treeModel;
        this.clusterPrior = treeClusteringVirusesPrior;
    }

    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

