/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.app.util.Arguments;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.tree.TreeStatistic;
import dr.geo.math.SphericalPolarCoordinates;
import dr.inference.model.Statistic;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.stats.DiscreteStatistics;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;

@Deprecated
public class DiffusionRateStatistic
extends Statistic.Abstract {
    public static final String DIFFUSION_RATE_STATISTIC = "diffusionRateStatistic";
    public static final String TREE_DISPERSION_STATISTIC = "treeDispersionStatistic";
    public static final String BOOLEAN_DIS_OPTION = "greatCircleDistance";
    public static final String MODE = "mode";
    public static final String MEDIAN = "median";
    public static final String AVERAGE = "average";
    public static final String WEIGHTED_AVERAGE = "weightedAverage";
    public static final String COEFFICIENT_OF_VARIATION = "coefficientOfVariation";
    public static final String STATISTIC = "statistic";
    public static final String DIFFUSION_RATE = "diffusionRate";
    public static final String WAVEFRONT_DISTANCE = "wavefrontDistance";
    public static final String WAVEFRONT_RATE = "wavefrontRate";
    public static final String DIFFUSION_COEFFICIENT = "diffusionCoefficient";
    public static final String HEIGHT_UPPER = "heightUpper";
    public static final String HEIGHT_LOWER = "heightLower";
    public static final String HEIGHT_LOWER_SERIE = "heightLowerSerie";
    public static final String CUMULATIVE = "cumulative";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("name", true), AttributeRule.newBooleanRule("greatCircleDistance", true), AttributeRule.newStringRule("mode", true), AttributeRule.newStringRule("statistic", true), AttributeRule.newDoubleRule("heightUpper", true), AttributeRule.newDoubleRule("heightLower", true), AttributeRule.newStringRule("heightLowerSerie", true), AttributeRule.newBooleanRule("cumulative", true), new ElementRule(AbstractMultivariateTraitLikelihood.class, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return DiffusionRateStatistic.DIFFUSION_RATE_STATISTIC;
        }

        @Override
        public String[] getParserNames() {
            return new String[]{this.getParserName(), DiffusionRateStatistic.TREE_DISPERSION_STATISTIC};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            summaryStatistic summaryStatistic2;
            Mode mode;
            String string = xMLObject.getAttribute("name", xMLObject.getId());
            boolean bl = xMLObject.getAttribute(DiffusionRateStatistic.BOOLEAN_DIS_OPTION, true);
            String string2 = xMLObject.getAttribute(DiffusionRateStatistic.MODE, DiffusionRateStatistic.WEIGHTED_AVERAGE);
            if (string2.equals(DiffusionRateStatistic.AVERAGE)) {
                mode = Mode.AVERAGE;
            } else if (string2.equals(DiffusionRateStatistic.MEDIAN)) {
                mode = Mode.MEDIAN;
            } else if (string2.equals(DiffusionRateStatistic.COEFFICIENT_OF_VARIATION)) {
                mode = Mode.COEFFICIENT_OF_VARIATION;
            } else if (string2.equals(DiffusionRateStatistic.WEIGHTED_AVERAGE)) {
                mode = Mode.WEIGHTED_AVERAGE;
            } else {
                System.err.println("Unknown mode: " + string2 + ". Reverting to weighted average");
                mode = Mode.WEIGHTED_AVERAGE;
            }
            String string3 = xMLObject.getAttribute(DiffusionRateStatistic.STATISTIC, DiffusionRateStatistic.DIFFUSION_RATE);
            if (string3.equals(DiffusionRateStatistic.DIFFUSION_RATE)) {
                summaryStatistic2 = summaryStatistic.DIFFUSION_RATE;
            } else if (string3.equals(DiffusionRateStatistic.WAVEFRONT_DISTANCE)) {
                summaryStatistic2 = summaryStatistic.WAVEFRONT_DISTANCE;
            } else if (string3.equals(DiffusionRateStatistic.WAVEFRONT_RATE)) {
                summaryStatistic2 = summaryStatistic.WAVEFRONT_RATE;
            } else if (string3.equals(DiffusionRateStatistic.DIFFUSION_COEFFICIENT)) {
                summaryStatistic2 = summaryStatistic.DIFFUSION_COEFFICIENT;
            } else {
                System.err.println("Unknown statistic: " + string3 + ". Reverting to diffusion rate");
                summaryStatistic2 = summaryStatistic.DIFFUSION_COEFFICIENT;
            }
            double d = xMLObject.getAttribute(DiffusionRateStatistic.HEIGHT_UPPER, Double.MAX_VALUE);
            double d2 = xMLObject.getAttribute(DiffusionRateStatistic.HEIGHT_LOWER, 0.0);
            double[] dArray = null;
            if (xMLObject.hasAttribute(DiffusionRateStatistic.HEIGHT_LOWER_SERIE)) {
                String string4 = xMLObject.getStringAttribute(DiffusionRateStatistic.HEIGHT_LOWER_SERIE);
                try {
                    dArray = DiffusionRateStatistic.parseVariableLengthDoubleArray(string4);
                }
                catch (Arguments.ArgumentException argumentException) {
                    System.err.println("Error reading heightLowerSerie");
                    System.exit(1);
                }
            }
            boolean bl2 = xMLObject.getAttribute(DiffusionRateStatistic.CUMULATIVE, false);
            ArrayList<AbstractMultivariateTraitLikelihood> arrayList = new ArrayList<AbstractMultivariateTraitLikelihood>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof AbstractMultivariateTraitLikelihood)) continue;
                AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(i);
                arrayList.add(abstractMultivariateTraitLikelihood);
            }
            return new DiffusionRateStatistic(string, arrayList, bl, mode, summaryStatistic2, d, d2, dArray, bl2);
        }

        @Override
        public String getParserDescription() {
            return "A statistic that returns the average of the branch diffusion rates";
        }

        @Override
        public Class getReturnType() {
            return TreeStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private boolean useGreatCircleDistances;
    private List<AbstractMultivariateTraitLikelihood> traitLikelihoods;
    private Mode summaryMode;
    private summaryStatistic summaryStat;
    private double heightUpper;
    private double[] heightLowers;
    private boolean cumulative;

    public DiffusionRateStatistic(String string, List<AbstractMultivariateTraitLikelihood> list, boolean bl, Mode mode, summaryStatistic summaryStatistic2, double d, double d2, double[] dArray, boolean bl2) {
        super(string);
        this.traitLikelihoods = list;
        this.useGreatCircleDistances = bl;
        this.summaryMode = mode;
        this.summaryStat = summaryStatistic2;
        this.heightUpper = d;
        if (dArray == null) {
            this.heightLowers = new double[]{d2};
        } else {
            this.heightLowers = DiffusionRateStatistic.extractUnique(dArray);
            Arrays.sort(this.heightLowers);
            DiffusionRateStatistic.reverse(this.heightLowers);
        }
        this.cumulative = bl2;
    }

    @Override
    public int getDimension() {
        return this.heightLowers.length;
    }

    @Override
    public double getStatisticValue(int n) {
        String string = this.traitLikelihoods.get(0).getTraitName();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double d5 = 0.0;
        double d6 = this.heightLowers[n];
        double d7 = Double.MAX_VALUE;
        if (this.heightLowers.length == 1) {
            d7 = this.heightUpper;
        } else if (n > 0 && !this.cumulative) {
            d7 = this.heightLowers[n - 1];
        }
        for (AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood : this.traitLikelihoods) {
            MutableTreeModel mutableTreeModel = abstractMultivariateTraitLikelihood.getTreeModel();
            BranchRateModel branchRateModel = abstractMultivariateTraitLikelihood.getBranchRateModel();
            for (int i = 0; i < mutableTreeModel.getNodeCount(); ++i) {
                double d8;
                double d9;
                double[] dArray;
                NodeRef nodeRef;
                NodeRef nodeRef2 = mutableTreeModel.getNode(i);
                if (nodeRef2 == mutableTreeModel.getRoot() || !(mutableTreeModel.getNodeHeight(nodeRef = mutableTreeModel.getParent(nodeRef2)) > d6) || !(mutableTreeModel.getNodeHeight(nodeRef2) < d7)) continue;
                double[] dArray2 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, nodeRef2, string);
                double[] dArray3 = dArray = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, nodeRef, string);
                double[] dArray4 = dArray2;
                double d10 = mutableTreeModel.getNodeHeight(nodeRef);
                double d11 = mutableTreeModel.getNodeHeight(nodeRef2);
                double d12 = branchRateModel != null ? branchRateModel.getBranchRate(mutableTreeModel, nodeRef2) : 1.0;
                MultivariateDiffusionModel multivariateDiffusionModel = abstractMultivariateTraitLikelihood.diffusionModel;
                double[] dArray5 = multivariateDiffusionModel.getPrecisionParameter().getParameterValues();
                if (mutableTreeModel.getNodeHeight(nodeRef) > d7) {
                    d10 = d7;
                    dArray3 = this.imputeValue(dArray2, dArray, d7, mutableTreeModel.getNodeHeight(nodeRef2), mutableTreeModel.getNodeHeight(nodeRef), dArray5, d12, false);
                }
                if (mutableTreeModel.getNodeHeight(nodeRef2) < d6) {
                    d11 = d6;
                    dArray4 = this.imputeValue(dArray2, dArray, d6, mutableTreeModel.getNodeHeight(nodeRef2), mutableTreeModel.getNodeHeight(nodeRef), dArray5, d12, false);
                }
                double d13 = d10 - d11;
                d += d13;
                double[] dArray6 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, mutableTreeModel.getRoot(), string);
                if (this.useGreatCircleDistances && dArray2.length == 2) {
                    SphericalPolarCoordinates sphericalPolarCoordinates = new SphericalPolarCoordinates(dArray4[0], dArray4[1]);
                    SphericalPolarCoordinates sphericalPolarCoordinates2 = new SphericalPolarCoordinates(dArray3[0], dArray3[1]);
                    d9 = sphericalPolarCoordinates.distance(sphericalPolarCoordinates2);
                    d2 += d9;
                    d8 = Math.pow(d9, 2.0) / (4.0 * d13);
                    arrayList2.add(d8);
                    d5 += d8 * d13;
                    arrayList.add(d9 / d13);
                    SphericalPolarCoordinates sphericalPolarCoordinates3 = new SphericalPolarCoordinates(dArray6[0], dArray6[1]);
                    double d14 = sphericalPolarCoordinates3.distance(sphericalPolarCoordinates2);
                    if (!(d14 > d3)) continue;
                    d3 = d14;
                    d4 = d14 / (mutableTreeModel.getNodeHeight(mutableTreeModel.getRoot()) - d11);
                    if (d10 != d7) continue;
                    d3 = d9;
                    d4 = d9 / d13;
                    continue;
                }
                double d15 = this.getNativeDistance(dArray4, dArray3);
                d2 += d15;
                d9 = Math.pow(d15, 2.0) / (4.0 * d13);
                arrayList2.add(d9);
                d5 += d9 * d13;
                arrayList.add(d15 / d13);
                d8 = this.getNativeDistance(dArray4, dArray6);
                if (!(d8 > d3)) continue;
                d3 = d8;
                d4 = d8 / (mutableTreeModel.getNodeHeight(mutableTreeModel.getRoot()) - d11);
                if (d10 != d7) continue;
                d3 = d15;
                d4 = d15 / d13;
            }
        }
        if (this.summaryStat == summaryStatistic.DIFFUSION_RATE) {
            if (this.summaryMode == Mode.AVERAGE) {
                return DiscreteStatistics.mean(this.toArray(arrayList));
            }
            if (this.summaryMode == Mode.MEDIAN) {
                return DiscreteStatistics.median(this.toArray(arrayList));
            }
            if (this.summaryMode == Mode.COEFFICIENT_OF_VARIATION) {
                double d16 = DiscreteStatistics.mean(this.toArray(arrayList));
                return Math.sqrt(DiscreteStatistics.variance(this.toArray(arrayList), d16)) / d16;
            }
            return d2 / d;
        }
        if (this.summaryStat == summaryStatistic.DIFFUSION_COEFFICIENT) {
            if (this.summaryMode == Mode.AVERAGE) {
                return DiscreteStatistics.mean(this.toArray(arrayList2));
            }
            if (this.summaryMode == Mode.MEDIAN) {
                return DiscreteStatistics.median(this.toArray(arrayList2));
            }
            if (this.summaryMode == Mode.COEFFICIENT_OF_VARIATION) {
                double d17 = DiscreteStatistics.mean(this.toArray(arrayList2));
                return Math.sqrt(DiscreteStatistics.variance(this.toArray(arrayList2), d17)) / d17;
            }
            return d5 / d;
        }
        if (this.summaryStat == summaryStatistic.WAVEFRONT_DISTANCE) {
            return d3;
        }
        return d4;
    }

    private double getNativeDistance(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.pow(dArray2[i] - dArray[i], 2.0);
        }
        return Math.sqrt(d);
    }

    private double[] toArray(List<Double> list) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = Double.valueOf(list.get(i).toString());
        }
        return dArray;
    }

    private double[] imputeValue(double[] dArray, double[] dArray2, double d, double d2, double d3, double[] dArray3, double d4, boolean bl) {
        int n;
        double d5 = (d - d2) * d4;
        double d6 = (d3 - d) * d4;
        double d7 = 1.0 / d5 + 1.0 / d6;
        int n2 = dArray.length;
        double[][] dArray4 = new double[n2][n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray4[i][j] = dArray3[n3];
                ++n3;
            }
        }
        if (d5 == 0.0) {
            return dArray;
        }
        if (d6 == 0.0) {
            return dArray2;
        }
        double[] dArray5 = new double[n2];
        double[][] dArray6 = new double[n2][n2];
        for (int i = 0; i < n2; ++i) {
            dArray5[i] = (dArray[i] / d5 + dArray2[i] / d6) / d7;
            if (!bl) continue;
            for (n = i; n < n2; ++n) {
                double d8 = dArray4[i][n] * d7;
                dArray6[i][n] = d8;
                dArray6[n][i] = d8;
            }
        }
        if (bl) {
            dArray5 = MultivariateNormalDistribution.nextMultivariateNormalPrecision(dArray5, dArray6);
        }
        double[] dArray7 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray7[n] = dArray5[n];
        }
        return dArray7;
    }

    public static double[] parseVariableLengthDoubleArray(String string) throws Arguments.ArgumentException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                arrayList.add(Double.parseDouble(stringTokenizer.nextToken()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Arguments.ArgumentException();
            }
        }
        if (arrayList.size() > 0) {
            double[] dArray = new double[arrayList.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)arrayList.get(i);
            }
            return dArray;
        }
        return null;
    }

    @Override
    public String getDimensionName(int n) {
        if (this.getDimension() == 1) {
            return this.getStatisticName();
        }
        return this.getStatisticName() + ".height" + this.heightLowers[n];
    }

    public static void reverse(double[] dArray) {
        if (dArray == null) {
            return;
        }
        int n = 0;
        for (int i = dArray.length - 1; i > n; --i, ++n) {
            double d = dArray[i];
            dArray[i] = dArray[n];
            dArray[n] = d;
        }
    }

    public static double[] extractUnique(double[] dArray) {
        LinkedHashSet<Double> linkedHashSet = new LinkedHashSet<Double>();
        double[] dArray2 = dArray;
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            Double d = dArray2[i];
            linkedHashSet.add(d);
        }
        dArray2 = new double[linkedHashSet.size()];
        n = 0;
        for (Double d : linkedHashSet) {
            dArray2[n++] = d;
        }
        return dArray2;
    }

    static enum summaryStatistic {
        DIFFUSION_RATE,
        DIFFUSION_COEFFICIENT,
        WAVEFRONT_DISTANCE,
        WAVEFRONT_RATE;

    }

    static enum Mode {
        AVERAGE,
        WEIGHTED_AVERAGE,
        MEDIAN,
        COEFFICIENT_OF_VARIATION;

    }
}

